/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.service.ShoppingOrderLocalServiceUtil;
import com.liferay.portlet.shopping.service.permission.ShoppingPermission;

public class ShoppingOrderPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long orderId, String actionId) throws PortalException, SystemException {
        if (!ShoppingOrderPermission.contains(permissionChecker, groupId, orderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, ShoppingOrder order, String actionId) throws PortalException {
        if (!ShoppingOrderPermission.contains(permissionChecker, groupId, order, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long orderId, String actionId) throws PortalException, SystemException {
        ShoppingOrder order = ShoppingOrderLocalServiceUtil.getOrder((long)orderId);
        return ShoppingOrderPermission.contains(permissionChecker, groupId, order, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, ShoppingOrder order, String actionId) {
        if (ShoppingPermission.contains(permissionChecker, groupId, "MANAGE_ORDERS")) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(order.getCompanyId(), ShoppingOrder.class.getName(), order.getOrderId(), order.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(order.getGroupId(), ShoppingOrder.class.getName(), order.getOrderId(), actionId);
    }
}

