/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ucar.unidata.util.DatedThing;

public class DatedObject
implements DatedThing {
    private Date date;
    private Object object;

    public DatedObject() {
    }

    public DatedObject(Date date) {
        this(date, null);
    }

    public DatedObject(Date date, Object object) {
        this.date = date;
        this.object = object;
    }

    public static List select(Date startDate, Date endDate, List datedThings) {
        if (startDate.getTime() > endDate.getTime()) {
            Date tmp = startDate;
            startDate = endDate;
            endDate = tmp;
        }
        long t1 = startDate.getTime();
        long t2 = endDate.getTime();
        ArrayList<DatedThing> selected = new ArrayList<DatedThing>();
        for (int i = 0; i < datedThings.size(); ++i) {
            DatedThing datedThing = (DatedThing)datedThings.get(i);
            long time = datedThing.getDate().getTime();
            if (time < t1 || time > t2) continue;
            selected.add(datedThing);
        }
        return selected;
    }

    public static List wrap(List dates) {
        ArrayList<DatedObject> result = new ArrayList<DatedObject>();
        for (int i = 0; i < dates.size(); ++i) {
            result.add(new DatedObject((Date)dates.get(i)));
        }
        return result;
    }

    public static List unwrap(List datedThings) {
        ArrayList<Date> result = new ArrayList<Date>();
        for (int i = 0; i < datedThings.size(); ++i) {
            result.add(((DatedThing)datedThings.get(i)).getDate());
        }
        return result;
    }

    public static List getObjects(List datedObjects) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (datedObjects == null) {
            return result;
        }
        for (int i = 0; i < datedObjects.size(); ++i) {
            result.add(((DatedObject)datedObjects.get(i)).getObject());
        }
        return result;
    }

    public static List sort(List datedThings, final boolean ascending) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                DatedThing a1 = (DatedThing)o1;
                DatedThing a2 = (DatedThing)o2;
                int result = a1.getDate().compareTo(a2.getDate());
                if (!ascending) {
                    result = -result;
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Object[] array = datedThings.toArray();
        Arrays.sort(array, comp);
        List<Object> result = Arrays.asList(array);
        datedThings = new ArrayList<Object>();
        datedThings.addAll(result);
        return datedThings;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatedObject)) {
            return false;
        }
        DatedObject that = (DatedObject)o;
        if (!this.date.equals(that.date)) {
            return false;
        }
        if (this.object == null) {
            return that.object == null;
        }
        if (that.object == null) {
            return this.object == null;
        }
        return this.object.equals(that.object);
    }

    public void setDate(Date value) {
        this.date = value;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setObject(Object value) {
        this.object = value;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        if (this.object != null) {
            return "" + this.object;
        }
        return "";
    }
}

