/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class DescriptorEventManager
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Vector eventSelectors;
    protected transient Vector eventMethods;
    protected transient Vector eventListeners;
    protected transient Vector defaultEventListeners;
    protected transient Vector entityListenerEventListeners;
    protected transient DescriptorEventListener entityEventListener;
    protected transient List<DescriptorEventListener> internalListeners = new ArrayList<DescriptorEventListener>();
    protected transient Vector entityEventManagers;
    protected transient Vector entityListenerEventManagers;
    protected boolean excludeDefaultListeners = false;
    protected boolean excludeSuperclassListeners = false;
    protected boolean hasAnyEventListeners = false;
    public static final int PreWriteEvent = 0;
    public static final int PostWriteEvent = 1;
    public static final int PreDeleteEvent = 2;
    public static final int PostDeleteEvent = 3;
    public static final int PreInsertEvent = 4;
    public static final int PostInsertEvent = 5;
    public static final int PreUpdateEvent = 6;
    public static final int PostUpdateEvent = 7;
    public static final int PostBuildEvent = 8;
    public static final int PostRefreshEvent = 9;
    public static final int PostCloneEvent = 10;
    public static final int PostMergeEvent = 11;
    public static final int AboutToInsertEvent = 12;
    public static final int AboutToUpdateEvent = 13;
    public static final int AboutToDeleteEvent = 14;
    public static final int PrePersistEvent = 15;
    public static final int PreRemoveEvent = 16;
    public static final int PreUpdateWithChangesEvent = 17;
    protected static final int NumberOfEvents = 18;

    public DescriptorEventManager() {
        this.eventSelectors = NonSynchronizedVector.newInstance(18);
        this.eventMethods = NonSynchronizedVector.newInstance(18);
        for (int index = 0; index < 18; ++index) {
            this.eventSelectors.addElement(null);
            this.eventMethods.addElement(null);
        }
    }

    public void addDefaultEventListener(DescriptorEventListener listener) {
        this.getDefaultEventListeners().addElement(listener);
    }

    public void addEntityListenerEventListener(DescriptorEventListener listener) {
        this.getEntityListenerEventListeners().addElement(listener);
    }

    public void addListener(DescriptorEventListener listener) {
        this.getEventListeners().addElement(listener);
        this.setHasAnyEventListeners(true);
    }

    public void addinternalListener(DescriptorEventListener listener) {
        this.internalListeners.add(listener);
        this.setHasAnyEventListeners(true);
    }

    public Object clone() {
        DescriptorEventManager clone = null;
        try {
            clone = (DescriptorEventManager)super.clone();
            clone.setEventSelectors((Vector)this.getEventSelectors().clone());
            clone.setEventMethods((Vector)this.getEventMethods().clone());
            clone.setEventListeners(this.getEventListeners());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clone;
    }

    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeEvent(DescriptorEvent event) throws DescriptorException {
        block15: {
            try {
                event.getSession().startOperationProfile("DescriptorEvents");
                event.setDescriptor(this.getDescriptor());
                this.notifyListeners(event);
                this.notifyEJB30Listeners(event);
                if (event.getSource() instanceof DescriptorEventListener) {
                    this.notifyListener((DescriptorEventListener)event.getSource(), event);
                    return;
                }
                Method eventMethod = (Method)this.getEventMethods().elementAt(event.getEventCode());
                if (eventMethod == null) {
                    return;
                }
                try {
                    Object[] runtimeParameters = new Object[]{event};
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(eventMethod, event.getSource(), runtimeParameters));
                            break block15;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw DescriptorException.illegalAccessWhileEventExecution(eventMethod.getName(), this.getDescriptor(), throwableException);
                            }
                            throw DescriptorException.targetInvocationWhileEventExecution(eventMethod.getName(), this.getDescriptor(), throwableException);
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(eventMethod, event.getSource(), runtimeParameters);
                }
                catch (IllegalAccessException exception) {
                    throw DescriptorException.illegalAccessWhileEventExecution(eventMethod.getName(), this.getDescriptor(), exception);
                }
                catch (IllegalArgumentException exception) {
                    throw DescriptorException.illegalArgumentWhileObsoleteEventExecute(eventMethod.getName(), this.getDescriptor(), exception);
                }
                catch (InvocationTargetException exception) {
                    throw DescriptorException.targetInvocationWhileEventExecution(eventMethod.getName(), this.getDescriptor(), exception);
                }
            }
            finally {
                event.getSession().endOperationProfile("DescriptorEvents");
            }
        }
    }

    protected Method findMethod(int selector) throws DescriptorException {
        Class[] declarationParameters = new Class[]{ClassConstants.DescriptorEvent_Class};
        String methodName = (String)this.getEventSelectors().elementAt(selector);
        try {
            return Helper.getDeclaredMethod(this.getDescriptor().getJavaClass(), methodName, declarationParameters);
        }
        catch (NoSuchMethodException exception) {
            throw DescriptorException.noSuchMethodOnFindObsoleteMethod(methodName, this.getDescriptor(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityOnFindMethod(methodName, this.getDescriptor(), exception);
        }
    }

    public String getAboutToInsertSelector() {
        return (String)this.getEventSelectors().elementAt(12);
    }

    public String getAboutToUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(13);
    }

    public Vector getDefaultEventListeners() {
        if (this.defaultEventListeners == null) {
            this.defaultEventListeners = new NonSynchronizedVector();
        }
        return this.defaultEventListeners;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DescriptorEventListener getEntityEventListener() {
        return this.entityEventListener;
    }

    public Vector getEntityListenerEventListeners() {
        if (this.entityListenerEventListeners == null) {
            this.entityListenerEventListeners = new Vector();
        }
        return this.entityListenerEventListeners;
    }

    public Vector getEventListeners() {
        if (this.eventListeners == null) {
            this.eventListeners = NonSynchronizedVector.newInstance(1);
        }
        return this.eventListeners;
    }

    protected Vector getEventMethods() {
        if (this.eventMethods == null) {
            this.eventMethods = NonSynchronizedVector.newInstance(18);
            for (int index = 0; index < 18; ++index) {
                this.eventMethods.addElement(null);
            }
        }
        return this.eventMethods;
    }

    protected Vector getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = NonSynchronizedVector.newInstance(18);
            for (int index = 0; index < 18; ++index) {
                this.eventSelectors.addElement(null);
            }
        }
        return this.eventSelectors;
    }

    public String getPostBuildSelector() {
        return (String)this.getEventSelectors().elementAt(8);
    }

    public String getPostCloneSelector() {
        return (String)this.getEventSelectors().elementAt(10);
    }

    public String getPostDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(3);
    }

    public String getPostInsertSelector() {
        return (String)this.getEventSelectors().elementAt(5);
    }

    public String getPostMergeSelector() {
        return (String)this.getEventSelectors().elementAt(11);
    }

    public String getPostRefreshSelector() {
        return (String)this.getEventSelectors().elementAt(9);
    }

    public String getPostUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(7);
    }

    public String getPostWriteSelector() {
        return (String)this.getEventSelectors().elementAt(1);
    }

    public String getPrePersistSelector() {
        return (String)this.getEventSelectors().elementAt(15);
    }

    public String getPreDeleteSelector() {
        return (String)this.getEventSelectors().elementAt(2);
    }

    public String getPreInsertSelector() {
        return (String)this.getEventSelectors().elementAt(4);
    }

    public String getPreRemoveSelector() {
        return (String)this.getEventSelectors().elementAt(16);
    }

    public String getPreUpdateSelector() {
        return (String)this.getEventSelectors().elementAt(6);
    }

    public String getPreWriteSelector() {
        return (String)this.getEventSelectors().elementAt(0);
    }

    public boolean hasAnyEventListeners() {
        return this.hasAnyEventListeners || this.hasAnyListeners();
    }

    protected boolean hasAnyListeners() {
        return this.eventListeners != null && !this.eventListeners.isEmpty();
    }

    public boolean hasEntityEventListener() {
        return this.entityEventListener != null;
    }

    public boolean hasEntityListenerEventListeners() {
        return this.entityListenerEventListeners != null && this.entityListenerEventListeners.size() > 0;
    }

    public void initialize(AbstractSession session) {
        this.initializeEJB30EventManagers();
        if (this.hasEntityEventListener() || this.hasEntityListenerEventListeners()) {
            this.setHasAnyEventListeners(true);
        }
        if (this.hasAnyListeners() || DescriptorEventListener.class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            this.setHasAnyEventListeners(true);
        }
        for (int index = 0; index < 18; ++index) {
            if (this.getEventSelectors().elementAt(index) == null) continue;
            this.setHasAnyEventListeners(true);
            this.getEventMethods().setElementAt(this.findMethod(index), index);
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorEventManager parentEventManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager();
            if (parentEventManager.hasAnyEventListeners()) {
                this.setHasAnyEventListeners(true);
            }
            for (int index = 0; index < 18; ++index) {
                if (this.getEventSelectors().get(index) != null || parentEventManager.getEventSelectors().get(index) == null) continue;
                this.setHasAnyEventListeners(true);
                this.getEventSelectors().set(index, parentEventManager.getEventSelectors().get(index));
                this.getEventMethods().set(index, parentEventManager.getEventMethods().get(index));
            }
        }
    }

    protected void initializeEJB30EventManagers() {
        this.entityEventManagers = new NonSynchronizedVector();
        this.entityListenerEventManagers = new NonSynchronizedVector();
        if (this.hasEntityEventListener()) {
            this.entityEventManagers.add(this);
        }
        if (this.hasEntityListenerEventListeners()) {
            this.entityListenerEventManagers.add(this);
        }
        ClassDescriptor currentDescriptor = this.getDescriptor();
        boolean excludeEntityListeners = this.excludeSuperclassListeners();
        while (currentDescriptor.isChildDescriptor()) {
            DescriptorEventManager eventManager = (currentDescriptor = currentDescriptor.getInheritancePolicy().getParentDescriptor()).getEventManager();
            if (eventManager.hasEntityEventListener()) {
                this.entityEventManagers.add(eventManager);
            }
            if (eventManager.hasEntityListenerEventListeners() && !excludeEntityListeners) {
                this.entityListenerEventManagers.add(eventManager);
            }
            excludeEntityListeners = eventManager.excludeSuperclassListeners();
        }
    }

    protected void notifyEJB30Listeners(DescriptorEvent event) {
        int index;
        if (!this.excludeDefaultListeners()) {
            for (int i = 0; i < this.getDefaultEventListeners().size(); ++i) {
                DescriptorEventListener listener = (DescriptorEventListener)this.getDefaultEventListeners().get(i);
                this.notifyListener(listener, event);
            }
        }
        for (index = this.entityListenerEventManagers.size() - 1; index >= 0; --index) {
            Vector entityListenerEventListeners = ((DescriptorEventManager)this.entityListenerEventManagers.get(index)).getEntityListenerEventListeners();
            for (int i = 0; i < entityListenerEventListeners.size(); ++i) {
                DescriptorEventListener listener = (DescriptorEventListener)entityListenerEventListeners.get(i);
                this.notifyListener(listener, event);
            }
        }
        for (index = this.entityEventManagers.size() - 1; index >= 0; --index) {
            DescriptorEventListener entityEventListener = ((DescriptorEventManager)this.entityEventManagers.get(index)).getEntityEventListener();
            if (entityEventListener.isOverriddenEvent(event, this.entityEventManagers)) continue;
            this.notifyListener(entityEventListener, event);
        }
        if (this.internalListeners != null) {
            for (DescriptorEventListener listener : this.internalListeners) {
                this.notifyListener(listener, event);
            }
        }
    }

    protected void notifyListener(DescriptorEventListener listener, DescriptorEvent event) throws DescriptorException {
        switch (event.getEventCode()) {
            case 0: {
                listener.preWrite(event);
                break;
            }
            case 1: {
                listener.postWrite(event);
                break;
            }
            case 2: {
                listener.preDelete(event);
                break;
            }
            case 3: {
                listener.postDelete(event);
                break;
            }
            case 4: {
                listener.preInsert(event);
                break;
            }
            case 5: {
                listener.postInsert(event);
                break;
            }
            case 6: {
                listener.preUpdate(event);
                break;
            }
            case 7: {
                listener.postUpdate(event);
                break;
            }
            case 11: {
                listener.postMerge(event);
                break;
            }
            case 10: {
                listener.postClone(event);
                break;
            }
            case 8: {
                listener.postBuild(event);
                break;
            }
            case 9: {
                listener.postRefresh(event);
                break;
            }
            case 12: {
                listener.aboutToInsert(event);
                break;
            }
            case 13: {
                listener.aboutToUpdate(event);
                break;
            }
            case 14: {
                listener.aboutToDelete(event);
                break;
            }
            case 15: {
                listener.prePersist(event);
                break;
            }
            case 16: {
                listener.preRemove(event);
                break;
            }
            case 17: {
                listener.preUpdateWithChanges(event);
                break;
            }
            default: {
                throw DescriptorException.invalidDescriptorEventCode(event, this.getDescriptor());
            }
        }
    }

    public void notifyListeners(DescriptorEvent event) {
        if (this.hasAnyListeners()) {
            for (int index = 0; index < this.getEventListeners().size(); ++index) {
                DescriptorEventListener listener = (DescriptorEventListener)this.getEventListeners().get(index);
                this.notifyListener(listener, event);
            }
        }
        if (this.getDescriptor().isChildDescriptor()) {
            this.getDescriptor().getInheritancePolicy().getParentDescriptor().getEventManager().notifyListeners(event);
        }
    }

    public void remoteInitialization(AbstractSession session) {
        this.eventMethods = new Vector(18);
        for (int index = 0; index < 18; ++index) {
            this.eventMethods.addElement(null);
        }
        this.initialize(session);
    }

    public void removeListener(DescriptorEventListener listener) {
        this.getEventListeners().removeElement(listener);
    }

    public void setAboutToInsertSelector(String aboutToInsertSelector) {
        this.getEventSelectors().setElementAt(aboutToInsertSelector, 12);
    }

    public void setAboutToUpdateSelector(String aboutToUpdateSelector) {
        this.getEventSelectors().setElementAt(aboutToUpdateSelector, 13);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEntityEventListener(DescriptorEventListener listener) {
        this.entityEventListener = listener;
    }

    protected void setEventListeners(Vector eventListeners) {
        this.eventListeners = eventListeners;
    }

    protected void setEventMethods(Vector eventMethods) {
        this.eventMethods = eventMethods;
    }

    protected void setEventSelectors(Vector eventSelectors) {
        this.eventSelectors = eventSelectors;
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.excludeDefaultListeners = excludeDefaultListeners;
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.excludeSuperclassListeners = excludeSuperclassListeners;
    }

    protected void setHasAnyEventListeners(boolean hasAnyEventListeners) {
        this.hasAnyEventListeners = hasAnyEventListeners;
    }

    public void setPostBuildSelector(String postBuildSelector) {
        this.getEventSelectors().setElementAt(postBuildSelector, 8);
    }

    public void setPostCloneSelector(String postCloneSelector) {
        this.getEventSelectors().setElementAt(postCloneSelector, 10);
    }

    public void setPostDeleteSelector(String postDeleteSelector) {
        this.getEventSelectors().setElementAt(postDeleteSelector, 3);
    }

    public void setPostInsertSelector(String postInsertSelector) {
        this.getEventSelectors().setElementAt(postInsertSelector, 5);
    }

    public void setPostMergeSelector(String postMergeSelector) {
        this.getEventSelectors().setElementAt(postMergeSelector, 11);
    }

    public void setPostRefreshSelector(String postRefreshSelector) {
        this.getEventSelectors().setElementAt(postRefreshSelector, 9);
    }

    public void setPostUpdateSelector(String postUpdateSelector) {
        this.getEventSelectors().setElementAt(postUpdateSelector, 7);
    }

    public void setPostWriteSelector(String postWriteSelector) {
        this.getEventSelectors().setElementAt(postWriteSelector, 1);
    }

    public void setPreDeleteSelector(String preDeleteSelector) {
        this.getEventSelectors().setElementAt(preDeleteSelector, 2);
    }

    public void setPreInsertSelector(String preInsertSelector) {
        this.getEventSelectors().setElementAt(preInsertSelector, 4);
    }

    public void setPrePersistSelector(String prePersistSelector) {
        this.getEventSelectors().setElementAt(prePersistSelector, 15);
    }

    public void setPreRemoveSelector(String preRemoveSelector) {
        this.getEventSelectors().setElementAt(preRemoveSelector, 16);
    }

    public void setPreUpdateSelector(String preUpdateSelector) {
        this.getEventSelectors().setElementAt(preUpdateSelector, 6);
    }

    public void setPreWriteSelector(String preWriteSelector) {
        this.getEventSelectors().setElementAt(preWriteSelector, 0);
    }
}

