/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.HtmlHeadingTag;
import org.jamwiki.parser.jflex.HtmlLinkTag;
import org.jamwiki.parser.jflex.HtmlTagItem;
import org.jamwiki.parser.jflex.ImageLinkTag;
import org.jamwiki.parser.jflex.IncludeOnlyTag;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.parser.jflex.JFlexTagItem;
import org.jamwiki.parser.jflex.JavascriptTag;
import org.jamwiki.parser.jflex.NoIncludeTag;
import org.jamwiki.parser.jflex.OnlyIncludeTag;
import org.jamwiki.parser.jflex.TemplateTag;
import org.jamwiki.parser.jflex.WikiBoldItalicTag;
import org.jamwiki.parser.jflex.WikiHeadingTag;
import org.jamwiki.parser.jflex.WikiLinkTag;
import org.jamwiki.parser.jflex.WikiReferenceTag;
import org.jamwiki.parser.jflex.WikiReferencesTag;
import org.jamwiki.parser.jflex.WikiSignatureTag;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JFlexLexer {
    private static final WikiLogger logger = WikiLogger.getLogger(JFlexLexer.class.getName());
    protected Stack<Integer> states = new Stack();
    protected ParserInput parserInput = null;
    protected ParserOutput parserOutput = null;
    protected int mode = 9;
    private Stack<JFlexTagItem> tagStack = new Stack();
    protected static final int TAG_TYPE_HTML_HEADING = 5;
    protected static final int TAG_TYPE_HTML_LINK = 10;
    protected static final int TAG_TYPE_IMAGE_LINK = 15;
    protected static final int TAG_TYPE_INCLUDE_ONLY = 20;
    protected static final int TAG_TYPE_JAVASCRIPT = 25;
    protected static final int TAG_TYPE_NO_INCLUDE = 30;
    protected static final int TAG_TYPE_ONLY_INCLUDE = 33;
    protected static final int TAG_TYPE_TEMPLATE = 35;
    protected static final int TAG_TYPE_WIKI_BOLD_ITALIC = 40;
    protected static final int TAG_TYPE_WIKI_HEADING = 45;
    protected static final int TAG_TYPE_WIKI_LINK = 50;
    protected static final int TAG_TYPE_WIKI_REFERENCE = 55;
    protected static final int TAG_TYPE_WIKI_REFERENCES = 60;
    protected static final int TAG_TYPE_WIKI_SIGNATURE = 65;
    private static final HtmlHeadingTag TAG_HTML_HEADING = new HtmlHeadingTag();
    private static final HtmlLinkTag TAG_HTML_LINK = new HtmlLinkTag();
    private static final ImageLinkTag TAG_IMAGE_LINK = new ImageLinkTag();
    private static final IncludeOnlyTag TAG_INCLUDE_ONLY = new IncludeOnlyTag();
    private static final JavascriptTag TAG_JAVASCRIPT = new JavascriptTag();
    private static final NoIncludeTag TAG_NO_INCLUDE = new NoIncludeTag();
    private static final OnlyIncludeTag TAG_ONLY_INCLUDE = new OnlyIncludeTag();
    private static final TemplateTag TAG_TEMPLATE = new TemplateTag();
    private static final WikiBoldItalicTag TAG_WIKI_BOLD_ITALIC = new WikiBoldItalicTag();
    private static final WikiHeadingTag TAG_WIKI_HEADING = new WikiHeadingTag();
    private static final WikiLinkTag TAG_WIKI_LINK = new WikiLinkTag();
    private static final WikiReferenceTag TAG_WIKI_REFERENCE = new WikiReferenceTag();
    private static final WikiReferencesTag TAG_WIKI_REFERENCES = new WikiReferencesTag();
    private static final WikiSignatureTag TAG_WIKI_SIGNATURE = new WikiSignatureTag();

    protected boolean allowHTML() {
        return Environment.getBooleanValue("allowHTML");
    }

    protected boolean allowJavascript() {
        return Environment.getBooleanValue("allow-javascript");
    }

    protected boolean allowTemplates() {
        return Environment.getBooleanValue("allow-templates");
    }

    protected void append(String content) {
        this.tagStack.peek().getTagContent().append(content);
    }

    protected void beginState(int state) {
        this.states.push(this.yystate());
        this.yybegin(state);
    }

    protected void endState() {
        if (this.states.empty()) {
            logger.warn("Attempt to call endState for an empty stack with text: " + this.yytext());
            return;
        }
        int next = this.states.pop();
        this.yybegin(next);
    }

    protected int getMode() {
        return this.mode;
    }

    public ParserInput getParserInput() {
        return this.parserInput;
    }

    public ParserOutput getParserOutput() {
        return this.parserOutput;
    }

    protected Stack<JFlexTagItem> getTagStack() {
        return this.tagStack;
    }

    public final void init(ParserInput parserInput, ParserOutput parserOutput, int mode) throws ParserException {
        this.parserInput = parserInput;
        this.parserOutput = parserOutput;
        this.mode = mode;
        this.tagStack.push(new JFlexTagItem("jflex-root", null));
    }

    private boolean isNextAfterListTags(String tagType) {
        for (int i = this.tagStack.size() - 1; i > 0; --i) {
            JFlexTagItem nextTag = (JFlexTagItem)this.tagStack.get(i);
            if (nextTag.getTagType().equals(tagType)) {
                return true;
            }
            if (nextTag.isListTag()) continue;
            return false;
        }
        return false;
    }

    protected String parse(int type, String raw, Object ... args) {
        if (this.getParserInput().getInfiniteLoopCount() >= Environment.getIntValue("parser-infinite-loop-limit")) {
            return raw;
        }
        JFlexParserTag jflexParserTag = null;
        switch (type) {
            case 5: {
                jflexParserTag = TAG_HTML_HEADING;
                break;
            }
            case 10: {
                jflexParserTag = TAG_HTML_LINK;
                break;
            }
            case 15: {
                jflexParserTag = TAG_IMAGE_LINK;
                break;
            }
            case 20: {
                jflexParserTag = TAG_INCLUDE_ONLY;
                break;
            }
            case 25: {
                jflexParserTag = TAG_JAVASCRIPT;
                break;
            }
            case 30: {
                jflexParserTag = TAG_NO_INCLUDE;
                break;
            }
            case 33: {
                jflexParserTag = TAG_ONLY_INCLUDE;
                break;
            }
            case 35: {
                jflexParserTag = TAG_TEMPLATE;
                break;
            }
            case 40: {
                jflexParserTag = TAG_WIKI_BOLD_ITALIC;
                break;
            }
            case 45: {
                jflexParserTag = TAG_WIKI_HEADING;
                break;
            }
            case 50: {
                jflexParserTag = TAG_WIKI_LINK;
                break;
            }
            case 55: {
                jflexParserTag = TAG_WIKI_REFERENCE;
                break;
            }
            case 60: {
                jflexParserTag = TAG_WIKI_REFERENCES;
                break;
            }
            case 65: {
                jflexParserTag = TAG_WIKI_SIGNATURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag type: " + type);
            }
        }
        try {
            return jflexParserTag.parse(this, raw, args);
        }
        catch (Throwable t) {
            logger.info("Unable to parse " + raw, t);
            return raw;
        }
    }

    protected JFlexTagItem peekTag() {
        return this.tagStack.peek();
    }

    protected JFlexTagItem popTag(String tagType) {
        if (this.tagStack.size() <= 1) {
            logger.warn("popTag called on an empty tag stack or on the root stack element.  Please report this error on jamwiki.org, and provide the wiki syntax for the topic being parsed.");
        }
        if (!this.peekTag().getTagType().equals(tagType)) {
            if (StringUtils.equals((String)this.peekTag().getTagType(), (String)this.peekTag().getCloseTagOverride())) {
                return this.popTag(this.peekTag().getCloseTagOverride());
            }
            if (!JFlexTagItem.isListTag(tagType) && this.peekTag().isListItemTag() && this.isNextAfterListTags(tagType)) {
                this.popAllListTags();
                return this.popTag(tagType);
            }
            JFlexTagItem parent = null;
            if (this.tagStack.size() > 2) {
                parent = (JFlexTagItem)this.tagStack.get(this.tagStack.size() - 2);
            }
            if (parent != null && parent.getTagType().equals(tagType)) {
                parent.setCloseTagOverride(tagType);
                return this.popTag(this.peekTag().getTagType());
            }
            JFlexTagItem currentTag = this.tagStack.peek();
            currentTag.getTagContent().append("&lt;/" + tagType + "&gt;");
            return null;
        }
        JFlexTagItem currentTag = this.tagStack.peek();
        if (this.tagStack.size() > 1) {
            currentTag = this.tagStack.pop();
        }
        JFlexTagItem previousTag = this.tagStack.peek();
        if (!currentTag.isInlineTag() || currentTag.getTagType().equals("pre")) {
            String trimmedContent = StringUtils.stripEnd((String)previousTag.getTagContent().toString(), null);
            previousTag.getTagContent().replace(0, previousTag.getTagContent().length(), trimmedContent);
            previousTag.getTagContent().append('\n');
            previousTag.getTagContent().append(currentTag.toHtml());
            previousTag.getTagContent().append('\n');
        } else {
            previousTag.getTagContent().append(currentTag.toHtml());
        }
        return currentTag;
    }

    protected JFlexTagItem popTag(String tagType, String closeTagRaw) throws ParserException {
        if (tagType != null) {
            return this.popTag(tagType);
        }
        HtmlTagItem htmlTagItem = JFlexParserUtil.sanitizeHtmlTag(closeTagRaw);
        return this.popTag(htmlTagItem.getTagType());
    }

    protected String popAllTags() {
        JFlexTagItem currentTag;
        while (this.tagStack.size() > 1) {
            currentTag = this.tagStack.peek();
            this.popTag(currentTag.getTagType());
        }
        currentTag = this.tagStack.pop();
        return this.mode >= 8 ? currentTag.toHtml().trim() : currentTag.toHtml();
    }

    protected void pushTag(String tagType, String openTagRaw) throws ParserException {
        JFlexTagItem tag = new JFlexTagItem(tagType, openTagRaw);
        if (tag.isNonNestingTag() && this.peekTag().getTagType().equals(tag.getTagType())) {
            this.popTag(tag.getTagType());
        }
        this.tagStack.push(tag);
    }

    protected int currentListDepth() {
        JFlexTagItem tag;
        int depth = 0;
        int currentPos = this.tagStack.size() - 1;
        while (currentPos >= 0 && (StringUtils.equals((String)(tag = (JFlexTagItem)this.tagStack.get(currentPos)).getTagType(), (String)"li") || StringUtils.equals((String)tag.getTagType(), (String)"dd") || StringUtils.equals((String)tag.getTagType(), (String)"dt"))) {
            currentPos -= 2;
            ++depth;
        }
        return depth;
    }

    protected String calculateListItemType(char wikiSyntax) {
        if (wikiSyntax == '*' || wikiSyntax == '#') {
            return "li";
        }
        if (wikiSyntax == ';') {
            return "dt";
        }
        if (wikiSyntax == ':') {
            return "dd";
        }
        throw new IllegalArgumentException("Unrecognized wiki syntax: " + wikiSyntax);
    }

    protected String calculateListType(char wikiSyntax) {
        if (wikiSyntax == ';' || wikiSyntax == ':') {
            return "dl";
        }
        if (wikiSyntax == '#') {
            return "ol";
        }
        if (wikiSyntax == '*') {
            return "ul";
        }
        throw new IllegalArgumentException("Unrecognized wiki syntax: " + wikiSyntax);
    }

    protected void processListStack(String wikiSyntax) throws ParserException {
        int counterStart;
        String tagType;
        int currentDepth;
        while (!this.peekTag().isRootTag() && (this.peekTag().getTagType().equals("p") || this.peekTag().isInlineTag())) {
            this.popTag(this.peekTag().getTagType());
        }
        int previousDepth = this.currentListDepth();
        int tagsToPop = previousDepth - (currentDepth = wikiSyntax.length());
        if (tagsToPop > 0) {
            this.popListTags(tagsToPop);
            previousDepth -= tagsToPop;
        }
        for (int i = 0; i < previousDepth; ++i) {
            int tagPos = this.tagStack.size() - (previousDepth - i) * 2;
            tagType = ((JFlexTagItem)this.tagStack.get(tagPos)).getTagType();
            if (tagType.equals(this.calculateListType(wikiSyntax.charAt(i)))) continue;
            tagsToPop = previousDepth - i;
            this.popListTags(tagsToPop);
            previousDepth -= tagsToPop;
            break;
        }
        if (previousDepth == 0) {
            this.pushTag(this.calculateListType(wikiSyntax.charAt(0)), null);
            this.pushTag(this.calculateListItemType(wikiSyntax.charAt(0)), null);
        } else if (previousDepth == currentDepth) {
            tagType = this.tagStack.peek().getTagType();
            this.popTag(tagType);
            this.pushTag(this.calculateListItemType(wikiSyntax.charAt(previousDepth - 1)), null);
        }
        for (int i = counterStart = previousDepth > 1 ? previousDepth : 1; i < wikiSyntax.length(); ++i) {
            String previousTagType = this.tagStack.peek().getTagType();
            if (previousTagType.equals("dt")) {
                this.popTag("dt");
                if (!this.calculateListType(wikiSyntax.charAt(i)).equals("dl")) {
                    this.popTag("dl");
                    this.pushTag("dl", null);
                }
                this.pushTag("dd", null);
            }
            this.pushTag(this.calculateListType(wikiSyntax.charAt(i)), null);
            this.pushTag(this.calculateListItemType(wikiSyntax.charAt(i)), null);
        }
    }

    protected void popAllListTags() {
        while (!this.peekTag().isRootTag() && (this.peekTag().getTagType().equals("p") || this.peekTag().isInlineTag())) {
            this.popTag(this.peekTag().getTagType());
        }
        this.popListTags(this.currentListDepth());
    }

    private void popListTags(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Cannot pop a negative number: " + depth);
        }
        for (int i = 0; i < depth; ++i) {
            String tagType = this.tagStack.peek().getTagType();
            this.popTag(tagType);
            tagType = this.tagStack.peek().getTagType();
            this.popTag(tagType);
        }
    }

    protected void parseTableCell(String text, String tagType, String markup) throws ParserException {
        if (text == null) {
            throw new IllegalArgumentException("No text specified while parsing table cell");
        }
        text = text.trim();
        String openTagRaw = null;
        int pos = StringUtils.indexOfAnyBut((String)text, (String)markup);
        if (pos != -1) {
            if ((pos = (text = text.substring(pos)).indexOf(124)) != -1) {
                text = text.substring(0, pos);
            }
            openTagRaw = "<" + tagType + " " + text.trim() + ">";
        }
        this.pushTag(tagType, openTagRaw);
    }

    protected void processTableStack() {
        while (!this.peekTag().isRootTag() && (this.peekTag().getTagType().equals("p") || this.peekTag().isInlineTag())) {
            this.popTag(this.peekTag().getTagType());
        }
        String previousTagType = this.peekTag().getTagType();
        if (!(previousTagType.equals("caption") || previousTagType.equals("th") || previousTagType.equals("td"))) {
            return;
        }
        this.popTag(previousTagType);
    }

    protected void parseParagraphEnd(String raw) {
        if (this.mode >= 8 && this.peekTag().getTagType().equals("p")) {
            this.popTag("p");
        }
        int pushback = raw.length();
        int pos = raw.indexOf(10);
        if (pos != -1 && pos < raw.length()) {
            pushback = raw.substring(pos + 1).length();
        }
        this.yypushback(pushback);
    }

    protected void parseParagraphStart(String raw) throws ParserException {
        int pushback = raw.length();
        if (this.mode >= 8) {
            this.pushTag("p", null);
            int newlineCount = StringUtils.countMatches((String)raw, (String)"\n");
            if (newlineCount > 0) {
                pushback = StringUtils.stripStart((String)raw, (String)" \n\r\t").length();
            }
            if (newlineCount == 2) {
                this.append("<br />\n");
            }
        }
        this.yypushback(pushback);
    }

    protected void parseParagraphEmpty(String raw) throws ParserException {
        this.yypushback(StringUtils.stripStart((String)raw, (String)" \n\r\t").length() + 1);
        if (this.mode < 8) {
            return;
        }
        int newlineCount = 0;
        for (int i = 0; i < raw.length(); ++i) {
            if (raw.charAt(i) != '\n' || ++newlineCount % 2 != 0) continue;
            this.pushTag("p", null);
            this.append("<br />\n");
            this.popTag("p");
        }
    }

    public abstract void yybegin(int var1);

    public abstract String yylex() throws Exception;

    public abstract void yypushback(int var1);

    public abstract int yystate();

    public abstract String yytext();
}

