/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.login.AbstractLoginModule;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AnonymousLoginModule
extends AbstractLoginModule {
    public static final String PROMPT = "User name";
    protected static final Logger log = Logger.getLogger(AnonymousLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            WikiPrincipal ipAddr = new WikiPrincipal(request.getRemoteAddr());
            if (log.isDebugEnabled()) {
                HttpSession session = request.getSession(false);
                String sid = session == null ? "(null)" : session.getId();
                log.debug((Object)("Logged in session ID=" + sid + "; IP=" + ipAddr));
            }
            this.m_principals.add(ipAddr);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("IOException: " + e.getMessage()));
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
    }
}

