/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;

public class PortletConstants {
    public static final String DEFAULT_PREFERENCES = "<portlet-preferences />";
    public static final String FACEBOOK_INTEGRATION_FBML = "fbml";
    public static final String FACEBOOK_INTEGRATION_IFRAME = "iframe";
    public static final String INSTANCE_SEPARATOR = "_INSTANCE_";
    public static final String LAYOUT_SEPARATOR = "_LAYOUT_";
    public static final String USER_PRINCIPAL_STRATEGY_SCREEN_NAME = "screenName";
    public static final String USER_PRINCIPAL_STRATEGY_USER_ID = "userId";
    public static final String USER_SEPARATOR = "_USER_";
    public static final String WAR_SEPARATOR = "_WAR_";

    public static String assemblePortletId(String portletId, long userId) {
        return PortletConstants.assemblePortletId(portletId, userId, null);
    }

    public static String assemblePortletId(String portletId, long userId, String instanceId) {
        String rootPortletId = PortletConstants.getRootPortletId(portletId);
        StringBundler sb = new StringBundler(5);
        sb.append(rootPortletId);
        if (userId <= 0L) {
            userId = PortletConstants.getUserId(portletId);
        }
        if (userId > 0L) {
            sb.append(USER_SEPARATOR);
            sb.append(userId);
        }
        if (Validator.isNull(instanceId)) {
            instanceId = PortletConstants.getInstanceId(portletId);
        }
        if (Validator.isNotNull(instanceId)) {
            sb.append(INSTANCE_SEPARATOR);
            sb.append(instanceId);
        }
        return sb.toString();
    }

    public static String assemblePortletId(String portletId, String instanceId) {
        return PortletConstants.assemblePortletId(portletId, 0L, instanceId);
    }

    public static String getInstanceId(String portletId) {
        int pos = portletId.indexOf(INSTANCE_SEPARATOR);
        if (pos == -1) {
            return null;
        }
        return portletId.substring(pos + INSTANCE_SEPARATOR.length());
    }

    public static String getRootPortletId(String portletId) {
        int x = portletId.indexOf(USER_SEPARATOR);
        int y = portletId.indexOf(INSTANCE_SEPARATOR);
        if (x == -1 && y == -1) {
            return portletId;
        }
        if (x != -1) {
            return portletId.substring(0, x);
        }
        return portletId.substring(0, y);
    }

    public static long getUserId(String portletId) {
        int x = portletId.indexOf(USER_SEPARATOR);
        int y = portletId.indexOf(INSTANCE_SEPARATOR);
        if (x == -1) {
            return 0L;
        }
        if (y != -1) {
            return GetterUtil.getLong(portletId.substring(x + USER_SEPARATOR.length(), y));
        }
        return GetterUtil.getLong(portletId.substring(x + USER_SEPARATOR.length()));
    }

    public static boolean hasIdenticalRootPortletId(String portletId1, String portletId2) {
        String rootPortletId1 = PortletConstants.getRootPortletId(portletId1);
        String rootPortletId2 = PortletConstants.getRootPortletId(portletId2);
        return rootPortletId1.equals(rootPortletId2);
    }

    public static boolean hasInstanceId(String portletId) {
        return portletId.contains(INSTANCE_SEPARATOR);
    }

    public static boolean hasUserId(String portletId) {
        return portletId.contains(USER_SEPARATOR);
    }
}

