/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.xslcontent.action;

import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.xslcontent.util.XSLContentUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.validateUrls(actionRequest);
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected String[] getValidUrlPrefixes(ThemeDisplay themeDisplay) {
        String validUrlPrefixes = PropsUtil.get("xsl.content.valid.url.prefixes");
        validUrlPrefixes = XSLContentUtil.replaceUrlTokens(themeDisplay, validUrlPrefixes);
        return StringUtil.split((String)validUrlPrefixes);
    }

    protected boolean hasValidUrlPrefix(String[] validUrlPrefixes, String url) {
        if (validUrlPrefixes.length == 0) {
            return true;
        }
        String[] stringArray = validUrlPrefixes;
        int n = validUrlPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String validUrlPrefix = stringArray[n2];
            if (StringUtil.startsWith((String)url, (String)validUrlPrefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void validateUrls(ActionRequest actionRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] validUrlPrefixes = this.getValidUrlPrefixes(themeDisplay);
        String xmlUrl = this.getParameter((PortletRequest)actionRequest, "xmlUrl");
        if (!this.hasValidUrlPrefix(validUrlPrefixes, xmlUrl = XSLContentUtil.replaceUrlTokens(themeDisplay, xmlUrl))) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"xmlUrl");
        }
        String xslUrl = this.getParameter((PortletRequest)actionRequest, "xslUrl");
        if (!this.hasValidUrlPrefix(validUrlPrefixes, xslUrl = XSLContentUtil.replaceUrlTokens(themeDisplay, xslUrl))) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"xslUrl");
        }
    }
}

