/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import jodd.http.HttpBase;
import jodd.http.HttpException;
import jodd.http.HttpUtil;
import jodd.io.StreamUtil;
import jodd.io.StringInputStream;
import jodd.io.StringOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
extends HttpBase<HttpResponse> {
    protected int statusCode;
    protected String statusPhrase;

    public int statusCode() {
        return this.statusCode;
    }

    public HttpResponse statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String statusPhrase() {
        return this.statusPhrase;
    }

    public HttpResponse statusPhrase(String statusPhrase) {
        this.statusPhrase = statusPhrase;
        return this;
    }

    public HttpResponse unzip() {
        String contentEncoding = this.contentEncoding();
        if (contentEncoding != null && this.contentEncoding().equals("gzip") && this.body != null) {
            this.removeHeader("Content-Encoding");
            try {
                StringInputStream in = new StringInputStream(this.body, StringInputStream.Mode.STRIP);
                GZIPInputStream gzipInputStream = new GZIPInputStream(in);
                StringOutputStream out = new StringOutputStream();
                StreamUtil.copy((InputStream)gzipInputStream, (OutputStream)out);
                this.body(out.toString());
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
        }
        return this;
    }

    public String toString() {
        String formString = this.formString();
        StringBuilder response = new StringBuilder();
        response.append(this.httpVersion).append(" ").append(this.statusCode).append(" ").append(this.statusPhrase).append("\r\n");
        for (String key : this.headers.keySet()) {
            String[] values = this.headers.getStrings(key);
            String headerName = HttpUtil.prepareHeaderParameterName(key);
            for (String value : values) {
                response.append(headerName);
                response.append(": ");
                response.append(value);
                response.append("\r\n");
            }
        }
        response.append("\r\n");
        if (this.form != null) {
            response.append(formString);
        } else if (this.body != null) {
            response.append(this.body);
        }
        return response.toString();
    }

    public static HttpResponse readFrom(InputStream in) {
        String line;
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(in, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
        BufferedReader reader = new BufferedReader(inputStreamReader);
        HttpResponse httpResponse = new HttpResponse();
        try {
            line = reader.readLine();
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        if (line != null) {
            line = line.trim();
            int ndx = line.indexOf(32);
            httpResponse.httpVersion(line.substring(0, ndx));
            int ndx2 = line.indexOf(32, ndx + 1);
            httpResponse.statusCode(Integer.parseInt(line.substring(ndx, ndx2).trim()));
            httpResponse.statusPhrase(line.substring(ndx2).trim());
        }
        httpResponse.readHeaders(reader);
        httpResponse.readBody(reader);
        return httpResponse;
    }
}

