/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Call
extends RPCMessage {
    private DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();
    private SOAPMappingRegistry smr = new SOAPMappingRegistry();
    private SOAPTransport st = null;

    public Call() {
        this(null, null, null, null, null);
    }

    public Call(String string, String string2, Vector vector, Header header, String string3) {
        this(string, string2, vector, header, string3, new SOAPContext());
    }

    public Call(String string, String string2, Vector vector, Header header, String string3, SOAPContext sOAPContext) {
        super(string, string2, vector, header, string3, sOAPContext);
    }

    public void addBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        this.ctx.addBodyPart(mimeBodyPart);
    }

    public Envelope buildEnvelope() {
        return super.buildEnvelope(false);
    }

    public static Call extractFromEnvelope(Envelope envelope, ServiceManager serviceManager, SOAPContext sOAPContext) throws IllegalArgumentException {
        return (Call)RPCMessage.extractFromEnvelope(envelope, serviceManager, false, null, sOAPContext);
    }

    public static String getEnvelopeString(SOAPTransport sOAPTransport) throws SOAPException, MessagingException, IOException {
        SOAPContext sOAPContext = sOAPTransport.getResponseSOAPContext();
        BufferedReader bufferedReader = null;
        String string = null;
        MimeBodyPart mimeBodyPart = sOAPContext.getRootPart();
        if (mimeBodyPart.isMimeType("text/*")) {
            bufferedReader = sOAPTransport.receive();
            string = IOUtils.getStringFromReader(bufferedReader);
        }
        if (!mimeBodyPart.isMimeType("text/xml")) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported response content type \"" + mimeBodyPart.getContentType() + "\", must be: \"" + "text/xml" + "\"." + (string == null ? "" : " Response was:\n" + string));
        }
        return string;
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        return this.smr;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public Response invoke(URL uRL, String string) throws SOAPException {
        if (string == null) {
            string = "";
        }
        try {
            Envelope envelope = this.buildEnvelope();
            if (this.st == null) {
                this.st = new SOAPHTTPConnection();
            }
            this.st.send(uRL, string, null, envelope, this.smr, this.ctx);
            SOAPContext sOAPContext = this.st.getResponseSOAPContext();
            String string2 = Call.getEnvelopeString(this.st);
            Document document = this.xdb.parse(new InputSource(new StringReader(string2)));
            Element element = null;
            if (document == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + string2);
            }
            element = document.getDocumentElement();
            Envelope envelope2 = Envelope.unmarshall(element, sOAPContext);
            Response response = Response.extractFromEnvelope(envelope2, this.smr, sOAPContext);
            this.setTargetObjectURI(response.getFullTargetObjectURI());
            return response;
        }
        catch (MessagingException messagingException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, messagingException.getMessage(), messagingException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, iOException.getMessage(), iOException);
        }
    }

    public void setSOAPMappingRegistry(SOAPMappingRegistry sOAPMappingRegistry) {
        this.smr = sOAPMappingRegistry;
    }

    public void setSOAPTransport(SOAPTransport sOAPTransport) {
        this.st = sOAPTransport;
    }
}

