/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.DataHandler;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.db.AnsiDataHandler;
import org.jamwiki.db.DatabaseConnection;
import org.jamwiki.db.QueryHandler;
import org.jamwiki.db.SybaseASAQueryHandler;
import org.jamwiki.model.Interwiki;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.Role;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.model.WikiGroup;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.ParserUtil;
import org.jamwiki.utils.Encryption;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiDatabase {
    private static String CONNECTION_VALIDATION_QUERY = null;
    private static String EXISTENCE_VALIDATION_QUERY = null;
    private static final WikiLogger logger = WikiLogger.getLogger(WikiDatabase.class.getName());
    public static final String SPECIAL_PAGE_DIR = "pages";
    private static final String[][] JAMWIKI_DB_TABLE_INFO = new String[][]{{"jam_virtual_wiki", "virtual_wiki_id"}, {"jam_users", null}, {"jam_wiki_user", "wiki_user_id"}, {"jam_namespace", "namespace_id"}, {"jam_namespace_translation", "namespace_id"}, {"jam_topic", "topic_id"}, {"jam_topic_version", "topic_version_id"}, {"jam_file", "file_id"}, {"jam_file_version", "file_version_id"}, {"jam_category", null}, {"jam_group", "group_id"}, {"jam_group_members", "id"}, {"jam_role", null}, {"jam_authorities", null}, {"jam_group_authorities", null}, {"jam_recent_change", "topic_version_id"}, {"jam_log", null}, {"jam_watchlist", null}, {"jam_topic_links", null}, {"jam_interwiki", null}, {"jam_configuration", null}};

    private WikiDatabase() {
    }

    private static DataHandler findNewDataHandler(Properties props) {
        String handlerClassName = props.getProperty("database-type");
        if (handlerClassName.equals(Environment.getValue("database-type"))) {
            return WikiBase.getDataHandler();
        }
        logger.debug("Using NEW data handler: " + handlerClassName);
        return (DataHandler)Utilities.instantiateClass(handlerClassName);
    }

    public static int fixIncorrectTopicNamespaces() throws DataAccessException {
        int count = 0;
        List<VirtualWiki> virtualWikis = WikiBase.getDataHandler().getVirtualWikiList();
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            for (VirtualWiki virtualWiki : virtualWikis) {
                Map<Integer, String> topicNames = WikiDatabase.queryHandler().lookupTopicNames(virtualWiki.getVirtualWikiId(), true, conn);
                if (topicNames.isEmpty()) continue;
                ArrayList<Topic> topics = new ArrayList<Topic>();
                for (int topicId : topicNames.keySet()) {
                    Topic topic = new Topic(virtualWiki.getName(), topicNames.get(topicId));
                    topic.setTopicId(topicId);
                    topics.add(topic);
                }
                WikiDatabase.queryHandler().updateTopicNamespaces(topics, conn);
                count += topicNames.size();
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void migrateDatabase(Properties props, List<WikiMessage> errors) throws DataAccessException {
        block47: {
            ResultSet rs;
            Statement stmt;
            Connection from;
            Connection conn;
            QueryHandler newQueryHandler;
            block45: {
                block43: {
                    block44: {
                        if (StringUtils.equalsIgnoreCase((String)Environment.getValue("url"), (String)props.getProperty("url"))) {
                            errors.add(new WikiMessage("error.databaseconnection", "Cannot migrate to the same database"));
                            return;
                        }
                        DataHandler newDataHandler = WikiDatabase.findNewDataHandler(props);
                        newQueryHandler = null;
                        if (newDataHandler instanceof AnsiDataHandler) {
                            AnsiDataHandler dataHandler = (AnsiDataHandler)newDataHandler;
                            newQueryHandler = dataHandler.queryHandler();
                            logger.debug("Using NEW query handler: " + newQueryHandler.getClass().getName());
                        } else {
                            newQueryHandler = WikiDatabase.queryHandler();
                        }
                        conn = null;
                        from = null;
                        stmt = null;
                        rs = null;
                        conn = WikiDatabase.initializeNewDatabase(props, errors, newQueryHandler);
                        if (conn != null) break block43;
                        if (conn == null) break block44;
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (from != null) {
                        DatabaseConnection.closeConnection(from, stmt, rs);
                    }
                    return;
                }
                conn.setAutoCommit(true);
                from = DatabaseConnection.getConnection();
                from.setReadOnly(true);
                from.setAutoCommit(true);
                HashMap<Integer, Integer> topicVersions = new HashMap<Integer, Integer>();
                for (int i = 0; i < JAMWIKI_DB_TABLE_INFO.length; ++i) {
                    boolean isTopicTable = "jam_topic".equals(JAMWIKI_DB_TABLE_INFO[i][0]);
                    int topicIdColumn = 0;
                    int currentVersionColumn = 0;
                    int maxIndex = WikiDatabase.retrieveMaximumTableId(JAMWIKI_DB_TABLE_INFO[i][0], JAMWIKI_DB_TABLE_INFO[i][1]);
                    int RECORDS_PER_CYCLE = 25;
                    for (int j = 0; j <= maxIndex; j += RECORDS_PER_CYCLE) {
                        StringBuilder select = new StringBuilder("SELECT * FROM ").append(JAMWIKI_DB_TABLE_INFO[i][0]);
                        if (!StringUtils.isBlank((String)JAMWIKI_DB_TABLE_INFO[i][1])) {
                            if (j == 0) {
                                select.append(" WHERE ");
                            } else {
                                select.append(" WHERE ").append(JAMWIKI_DB_TABLE_INFO[i][1]).append(" > ").append(j);
                                select.append(" AND ");
                            }
                            select.append(JAMWIKI_DB_TABLE_INFO[i][1]).append(" <= ").append(j + RECORDS_PER_CYCLE);
                            select.append(" ORDER BY ").append(JAMWIKI_DB_TABLE_INFO[i][1]);
                        }
                        StringBuilder insert = new StringBuilder();
                        stmt = from.createStatement();
                        logger.info(select.toString());
                        rs = stmt.executeQuery(select.toString());
                        ResultSetMetaData md = rs.getMetaData();
                        insert.append("INSERT INTO ").append(JAMWIKI_DB_TABLE_INFO[i][0]).append('(');
                        StringBuilder values = new StringBuilder();
                        for (int k = 1; k <= md.getColumnCount(); ++k) {
                            if (k > 1) {
                                insert.append(',');
                                values.append(',');
                            }
                            String columnName = md.getColumnLabel(k);
                            if (isTopicTable) {
                                if ("topic_id".equalsIgnoreCase(columnName)) {
                                    topicIdColumn = k;
                                } else if ("current_version_id".equalsIgnoreCase(columnName)) {
                                    currentVersionColumn = k;
                                }
                            }
                            if (newQueryHandler instanceof SybaseASAQueryHandler && "login".equalsIgnoreCase(columnName)) {
                                columnName = "\"" + columnName + "\"";
                            }
                            insert.append(columnName);
                            values.append('?');
                        }
                        insert.append(") VALUES (").append((CharSequence)values).append(')');
                        logger.info(insert.toString());
                        PreparedStatement insertStmt = conn.prepareStatement(insert.toString());
                        while (rs.next()) {
                            Integer topicId = null;
                            Integer currentVersionId = null;
                            for (int k = 1; k <= md.getColumnCount(); ++k) {
                                Object o = rs.getObject(k);
                                if (isTopicTable) {
                                    if (k == topicIdColumn) {
                                        topicId = (Integer)o;
                                    } else if (k == currentVersionColumn) {
                                        currentVersionId = (Integer)o;
                                    }
                                }
                                if (rs.wasNull() || isTopicTable && k == currentVersionColumn) {
                                    insertStmt.setNull(k, md.getColumnType(k));
                                    continue;
                                }
                                insertStmt.setObject(k, rs.getObject(k));
                            }
                            insertStmt.executeUpdate();
                            if (topicId == null || currentVersionId == null) continue;
                            topicVersions.put(topicId, currentVersionId);
                        }
                        rs.close();
                        DatabaseConnection.closeStatement(stmt);
                        DatabaseConnection.closeStatement(insertStmt);
                    }
                }
                String updateSql = "UPDATE jam_topic SET current_version_id = ? WHERE topic_id = ?";
                logger.info(updateSql);
                PreparedStatement update = conn.prepareStatement(updateSql);
                for (Integer topicId : topicVersions.keySet()) {
                    Integer topicVersionId = (Integer)topicVersions.get(topicId);
                    update.setObject(1, topicVersionId);
                    update.setObject(2, topicId);
                    update.executeUpdate();
                }
                if (conn == null) break block45;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (from != null) {
                DatabaseConnection.closeConnection(from, stmt, rs);
            }
            break block47;
            catch (Exception e) {
                block46: {
                    try {
                        logger.error("Error attempting to migrate the database", e);
                        errors.add(new WikiMessage("error.unknown", e.getMessage()));
                        try {
                            newQueryHandler.dropTables(conn);
                        }
                        catch (Exception ex) {
                            logger.warn("Unable to drop tables in NEW database following failed migration", ex);
                        }
                        if (conn == null) break block46;
                    }
                    catch (Throwable throwable) {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        if (from != null) {
                            DatabaseConnection.closeConnection(from, stmt, rs);
                        }
                        throw throwable;
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                }
                if (from != null) {
                    DatabaseConnection.closeConnection(from, stmt, rs);
                }
            }
        }
    }

    protected static String getConnectionValidationQuery() {
        return !StringUtils.isBlank((String)CONNECTION_VALIDATION_QUERY) ? CONNECTION_VALIDATION_QUERY : null;
    }

    protected static String getExistenceValidationQuery() {
        return !StringUtils.isBlank((String)EXISTENCE_VALIDATION_QUERY) ? EXISTENCE_VALIDATION_QUERY : null;
    }

    public static synchronized void initialize() {
        try {
            CONNECTION_VALIDATION_QUERY = WikiDatabase.queryHandler().connectionValidationQuery();
            EXISTENCE_VALIDATION_QUERY = WikiDatabase.queryHandler().existenceValidationQuery();
            DatabaseConnection.closeConnectionPool();
        }
        catch (Exception e) {
            logger.error("Unable to initialize database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection initializeNewDatabase(Properties props, List<WikiMessage> errors, QueryHandler newQueryHandler) {
        Connection conn;
        block20: {
            String driver = props.getProperty("driver");
            String url = props.getProperty("url");
            String userName = props.getProperty("db-user");
            String password = Encryption.getEncryptedProperty("db-password", props);
            conn = null;
            try {
                conn = DatabaseConnection.getTestConnection(driver, url, userName, password);
                conn.setAutoCommit(true);
            }
            catch (Exception e) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                errors.add(new WikiMessage("error.databaseconnection", e.getMessage()));
                return null;
            }
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.executeQuery(newQueryHandler.existenceValidationQuery());
                errors.add(new WikiMessage("setup.error.migrate"));
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                Connection ex = null;
                return ex;
            }
            catch (Exception ex) {
                logger.debug("NEW Database does not contain any JAMWiki instance");
            }
            finally {
                DatabaseConnection.closeStatement(stmt);
            }
            try {
                newQueryHandler.createTables(conn);
            }
            catch (Exception e) {
                logger.error("Error attempting to migrate the database", e);
                errors.add(new WikiMessage("error.unknown", e.getMessage()));
                try {
                    newQueryHandler.dropTables(conn);
                }
                catch (Exception ex) {
                    logger.warn("Unable to drop tables in NEW database following failed migration", ex);
                }
                if (conn == null) break block20;
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
        }
        return conn;
    }

    public static synchronized void shutdown() {
        try {
            DatabaseConnection.closeConnectionPool();
        }
        catch (Exception e) {
            logger.error("Unable to close the connection pool on shutdown", e);
        }
    }

    protected static void purgeData(Connection conn) throws DataAccessException {
        WikiDatabase.queryHandler().dropTables(conn);
        try {
            WikiDatabase.queryHandler().createTables(conn);
        }
        catch (Exception e) {
            WikiDatabase.queryHandler().dropTables(conn);
        }
    }

    protected static QueryHandler queryHandler() throws DataAccessException {
        if (WikiBase.getDataHandler() instanceof AnsiDataHandler) {
            AnsiDataHandler dataHandler = (AnsiDataHandler)WikiBase.getDataHandler();
            return dataHandler.queryHandler();
        }
        throw new DataAccessException("Unable to determine query handler");
    }

    protected static String readSpecialPage(Locale locale, String pageName) throws IOException {
        String contents = null;
        String filename = null;
        String language = null;
        String country = null;
        if (locale != null) {
            language = locale.getLanguage();
            country = locale.getCountry();
        }
        String subdirectory = "";
        if (!StringUtils.isBlank((String)language) && !StringUtils.isBlank((String)country)) {
            try {
                subdirectory = SPECIAL_PAGE_DIR + File.separator + language + "_" + country;
                filename = subdirectory + File.separator + WikiUtil.encodeForFilename(pageName) + ".txt";
                contents = Utilities.readFile(filename);
            }
            catch (IOException e) {
                logger.info("No locale-specific file is available for " + filename + ", checking for a language-specific version.");
            }
        }
        if (contents == null && !StringUtils.isBlank((String)language)) {
            try {
                subdirectory = SPECIAL_PAGE_DIR + File.separator + language;
                filename = subdirectory + File.separator + WikiUtil.encodeForFilename(pageName) + ".txt";
                contents = Utilities.readFile(filename);
            }
            catch (IOException e) {
                logger.info("No language-specific file is available for " + filename + " so the default will be used.");
            }
        }
        if (contents == null) {
            try {
                subdirectory = SPECIAL_PAGE_DIR;
                filename = subdirectory + File.separator + WikiUtil.encodeForFilename(pageName) + ".txt";
                contents = Utilities.readFile(filename);
            }
            catch (IOException e) {
                logger.warn("Default topic initialization file " + filename + " could not be read", e);
                throw e;
            }
        }
        return contents;
    }

    public static int[] rebuildTopicMetadata() throws DataAccessException {
        int numErrors = 0;
        int numUpdated = 0;
        List<VirtualWiki> virtualWikis = WikiBase.getDataHandler().getVirtualWikiList();
        for (VirtualWiki virtualWiki : virtualWikis) {
            List<String> topicNames = WikiBase.getDataHandler().getAllTopicNames(virtualWiki.getName(), false);
            if (topicNames.isEmpty()) continue;
            for (String topicName : topicNames) {
                try {
                    Topic topic = WikiBase.getDataHandler().lookupTopic(virtualWiki.getName(), topicName, false, null);
                    if (topic == null) {
                        logger.warn("Invalid topic record found, possible database integrity issue: " + virtualWiki.getName() + " / " + topicName);
                        ++numErrors;
                        continue;
                    }
                    ParserOutput parserOutput = ParserUtil.parserOutput(topic.getTopicContent(), virtualWiki.getName(), topicName);
                    WikiBase.getDataHandler().writeTopic(topic, null, parserOutput.getCategories(), parserOutput.getLinks());
                    ++numUpdated;
                }
                catch (ParserException e) {
                    logger.error("Failure while regenerating topic metadata for " + virtualWiki.getName() + " / " + topicName + ": " + e.getMessage());
                    ++numErrors;
                }
                catch (DataAccessException e) {
                    logger.error("Failure while regenerating topic metadata for " + virtualWiki.getName() + " / " + topicName + ": " + e.getMessage());
                    ++numErrors;
                }
                catch (WikiException e) {
                    logger.error("Failure while regenerating topic metadata for " + virtualWiki.getName() + " / " + topicName + ": " + e.getMessage());
                    ++numErrors;
                }
            }
        }
        int[] resultArray = new int[]{numUpdated, numErrors};
        return resultArray;
    }

    protected static void releaseConnection(Connection conn, Object transactionObject) throws SQLException {
        if (transactionObject instanceof Connection) {
            return;
        }
        WikiDatabase.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        try {
            conn.commit();
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int retrieveMaximumTableId(String tableName, String primaryIdColumnName) throws SQLException {
        int n;
        if (StringUtils.isBlank((String)tableName) || StringUtils.isBlank((String)primaryIdColumnName)) {
            return 1;
        }
        String sql = "select max(" + primaryIdColumnName + ") as max_table_id from " + tableName;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            n = rs.next() ? rs.getInt("max_table_id") : 0;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt, rs);
        return n;
    }

    protected static void setup(Locale locale, WikiUser user, String username, String encryptedPassword) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            WikiDatabase.queryHandler().createTables(conn);
            WikiDatabase.setupDefaultVirtualWiki();
            WikiDatabase.setupDefaultNamespaces();
            WikiDatabase.setupDefaultInterwikis();
            WikiDatabase.setupRoles();
            WikiDatabase.setupGroups();
            WikiDatabase.setupAdminUser(user, username, encryptedPassword);
            WikiDatabase.setupSpecialPages(locale, user);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Unable to set up database tables", e);
            try {
                Connection conn = DatabaseConnection.getConnection();
                WikiDatabase.queryHandler().dropTables(conn);
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new DataAccessException(e);
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Unable to set up database tables", e);
            try {
                Connection conn = DatabaseConnection.getConnection();
                WikiDatabase.queryHandler().dropTables(conn);
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Unable to set up database tables", e);
            try {
                Connection conn = DatabaseConnection.getConnection();
                WikiDatabase.queryHandler().dropTables(conn);
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    private static void setupAdminUser(WikiUser user, String username, String encryptedPassword) throws DataAccessException, WikiException {
        logger.info("Creating wiki admin user");
        if (user == null) {
            throw new IllegalArgumentException("Cannot pass null or anonymous WikiUser object to setupAdminUser");
        }
        if (WikiBase.getDataHandler().lookupWikiUser(user.getUserId()) != null) {
            logger.warn("Admin user already exists");
        }
        WikiBase.getDataHandler().writeWikiUser(user, username, encryptedPassword);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(Role.ROLE_ADMIN.getAuthority());
        roles.add(Role.ROLE_IMPORT.getAuthority());
        roles.add(Role.ROLE_SYSADMIN.getAuthority());
        roles.add(Role.ROLE_TRANSLATE.getAuthority());
        WikiBase.getDataHandler().writeRoleMapUser(user.getUsername(), roles);
    }

    public static void setupDefaultDatabase(Properties props) {
        props.setProperty("driver", "org.hsqldb.jdbcDriver");
        props.setProperty("database-type", "org.jamwiki.db.HSqlDataHandler");
        props.setProperty("db-user", "sa");
        props.setProperty("db-password", "");
        File file = new File(props.getProperty("homeDir"), "database");
        if (!file.exists()) {
            file.mkdirs();
        }
        String url = "jdbc:hsqldb:file:" + new File(file.getPath(), "jamwiki").getPath() + ";shutdown=true";
        props.setProperty("url", url);
    }

    protected static void setupDefaultInterwikis() throws DataAccessException, WikiException {
        logger.info("Creating default interwiki records");
        Interwiki jamwiki = new Interwiki("jamwiki", "http://jamwiki.org/wiki/en/{0}", "JAMWiki");
        WikiBase.getDataHandler().writeInterwiki(jamwiki);
        Interwiki mediawiki = new Interwiki("mediawiki", "http://www.mediawiki.org/wiki/{0}", "MediaWiki");
        WikiBase.getDataHandler().writeInterwiki(mediawiki);
        Interwiki metawikipedia = new Interwiki("metawikipedia", "http://meta.wikimedia.org/wiki/{0}", "Wikimedia Meta-Wiki");
        WikiBase.getDataHandler().writeInterwiki(metawikipedia);
        Interwiki wiki = new Interwiki("wiki", "http://c2.com/cgi/wiki?{0}", "WikiWiki");
        WikiBase.getDataHandler().writeInterwiki(wiki);
        Interwiki wikia = new Interwiki("wikia", "http://www.wikia.com/wiki/index.php/{0}", "Wikia");
        WikiBase.getDataHandler().writeInterwiki(wikia);
        Interwiki wikipedia = new Interwiki("wikipedia", "http://en.wikipedia.org/wiki/{0}", "Wikipedia");
        WikiBase.getDataHandler().writeInterwiki(wikipedia);
        Interwiki wikiquote = new Interwiki("wikiquote", "http://en.wikiquote.org/wiki/{0}", "Wikiquote");
        WikiBase.getDataHandler().writeInterwiki(wikiquote);
        Interwiki wikinews = new Interwiki("wikinews", "http://en.wikinews.org/wiki/{0}", "Wikinews");
        WikiBase.getDataHandler().writeInterwiki(wikinews);
    }

    protected static void setupDefaultNamespaces() throws DataAccessException, WikiException {
        logger.info("Creating default wiki namespaces");
        ArrayList<Namespace> defaultNamespaces = new ArrayList<Namespace>(Namespace.DEFAULT_NAMESPACES.values());
        for (int i = 0; i < defaultNamespaces.size(); ++i) {
            Namespace mainNamespace = (Namespace)defaultNamespaces.get(i);
            Namespace commentsNamespace = null;
            if (defaultNamespaces.size() > i + 1) {
                commentsNamespace = (Namespace)defaultNamespaces.get(i + 1);
                if (mainNamespace.equals(commentsNamespace.getMainNamespace())) {
                    ++i;
                } else {
                    commentsNamespace = null;
                }
            }
            WikiBase.getDataHandler().writeNamespace(mainNamespace, commentsNamespace);
        }
    }

    private static void setupDefaultVirtualWiki() throws DataAccessException, WikiException {
        logger.info("Creating default virtual wiki");
        VirtualWiki virtualWiki = VirtualWiki.defaultVirtualWiki();
        WikiBase.getDataHandler().writeVirtualWiki(virtualWiki);
    }

    protected static void setupGroups() throws DataAccessException, WikiException {
        logger.info("Creating default wiki groups");
        WikiGroup group = new WikiGroup();
        group.setName("GROUP_ANONYMOUS");
        group.setDescription("All non-logged in users are automatically assigned to the anonymous group.");
        WikiBase.getDataHandler().writeWikiGroup(group);
        ArrayList<String> anonymousRoles = new ArrayList<String>();
        anonymousRoles.add(Role.ROLE_EDIT_EXISTING.getAuthority());
        anonymousRoles.add(Role.ROLE_EDIT_NEW.getAuthority());
        anonymousRoles.add(Role.ROLE_UPLOAD.getAuthority());
        anonymousRoles.add(Role.ROLE_VIEW.getAuthority());
        WikiBase.getDataHandler().writeRoleMapGroup(group.getGroupId(), anonymousRoles);
        group = new WikiGroup();
        group.setName("GROUP_REGISTERED_USER");
        group.setDescription("All logged in users are automatically assigned to the registered user group.");
        WikiBase.getDataHandler().writeWikiGroup(group);
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add(Role.ROLE_EDIT_EXISTING.getAuthority());
        userRoles.add(Role.ROLE_EDIT_NEW.getAuthority());
        userRoles.add(Role.ROLE_MOVE.getAuthority());
        userRoles.add(Role.ROLE_UPLOAD.getAuthority());
        userRoles.add(Role.ROLE_VIEW.getAuthority());
        WikiBase.getDataHandler().writeRoleMapGroup(group.getGroupId(), userRoles);
    }

    protected static void setupRoles() throws DataAccessException, WikiException {
        logger.info("Creating default wiki roles");
        Role role = Role.ROLE_ADMIN;
        role.setDescription("Provides the ability to perform wiki maintenance tasks not available to normal users.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_EDIT_EXISTING;
        role.setDescription("Allows a user to edit an existing topic.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_EDIT_NEW;
        role.setDescription("Allows a user to create a new topic.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_IMPORT;
        role.setDescription("Allows a user to import data from a file.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_MOVE;
        role.setDescription("Allows a user to move a topic to a different name.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_SYSADMIN;
        role.setDescription("Allows access to set database parameters, modify parser settings, and set other wiki system settings.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_TRANSLATE;
        role.setDescription("Allows access to the translation tool used for modifying the values of message keys used to display text on the wiki.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_UPLOAD;
        role.setDescription("Allows a user to upload a file to the wiki.");
        WikiBase.getDataHandler().writeRole(role, false);
        role = Role.ROLE_VIEW;
        role.setDescription("Allows a user to view topics on the wiki.");
        WikiBase.getDataHandler().writeRole(role, false);
    }

    protected static void setupSpecialPage(Locale locale, String virtualWiki, String topicName, WikiUser user, boolean adminOnly) throws DataAccessException, WikiException {
        logger.info("Setting up special page " + virtualWiki + " / " + topicName);
        if (user == null) {
            throw new IllegalArgumentException("Cannot pass null WikiUser object to setupSpecialPage");
        }
        String contents = null;
        try {
            contents = WikiDatabase.readSpecialPage(locale, topicName);
        }
        catch (IOException e) {
            throw new DataAccessException(e);
        }
        Topic topic = new Topic(virtualWiki, topicName);
        topic.setTopicContent(contents);
        topic.setAdminOnly(adminOnly);
        int charactersChanged = StringUtils.length((String)contents);
        TopicVersion topicVersion = new TopicVersion(user, user.getLastLoginIpAddress(), "Automatically created by system setup", contents, charactersChanged);
        WikiBase.getDataHandler().writeTopic(topic, topicVersion, null, null);
    }

    private static void setupSpecialPages(Locale locale, WikiUser user) throws DataAccessException, WikiException {
        List<VirtualWiki> all = WikiBase.getDataHandler().getVirtualWikiList();
        for (VirtualWiki virtualWiki : all) {
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "StartingPoints", user, false);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "LeftMenu", user, true);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "BottomArea", user, true);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "StyleSheet", user, true);
        }
    }
}

