/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.rewriter;

import org.portletbridge.UrlRewriter;
import org.portletbridge.UrlUtils;

public class FullUrlRewriter
implements UrlRewriter {
    private String currentUrl;
    private String currentProtocolHostPort;
    private String newBaseUrl;
    private String newBasePath;
    private String newBaseContext;

    public FullUrlRewriter(String currentUrl, String newBaseUrl) {
        this.currentUrl = currentUrl;
        this.newBaseUrl = newBaseUrl;
        this.newBaseContext = this.getBaseContext(newBaseUrl);
        this.newBasePath = this.newBaseContext + '/' + UrlUtils.getProtocolHostPort(newBaseUrl.substring(this.newBaseContext.length() + 1));
        this.currentProtocolHostPort = UrlUtils.getProtocolHostPort(currentUrl);
    }

    protected String getBaseContext(String newBaseUrl) {
        int indexOfColon = newBaseUrl.indexOf(58);
        if (indexOfColon != -1) {
            int lastIndexOfContext = newBaseUrl.lastIndexOf(47, indexOfColon);
            if (lastIndexOfContext == -1) {
                throw new RuntimeException("BaseUrl must have full url in it e.g. /new/http://asdfadsaf:80 but is currently " + newBaseUrl);
            }
            return newBaseUrl.substring(0, lastIndexOfContext);
        }
        throw new RuntimeException("BaseUrl must have full url in it e.g. /new/http://asdfadsaf:80 but is currently " + newBaseUrl);
    }

    public String rewrite(String url) {
        if (UrlUtils.isRelativeHttp(url)) {
            return url;
        }
        if (UrlUtils.isAbsoluteWithHostHttp(url)) {
            String protocol = UrlUtils.getProtocol(this.currentUrl);
            return this.newBaseContext + '/' + protocol + ':' + url;
        }
        if (UrlUtils.isAbsoluteHttp(url)) {
            return UrlUtils.safeAppend(this.newBasePath, url);
        }
        if (UrlUtils.isFullHttp(url)) {
            if (this.currentProtocolHostPort != null) {
                if (url.startsWith(this.currentProtocolHostPort)) {
                    if (url.length() == this.currentProtocolHostPort.length()) {
                        return this.newBasePath + '/';
                    }
                    return UrlUtils.safeAppend(this.newBasePath, url.substring(this.currentProtocolHostPort.length()));
                }
                String protocolHostPort = UrlUtils.getProtocolHostPort(url);
                if (protocolHostPort.length() == url.length()) {
                    return this.newBaseContext + '/' + url + '/';
                }
                return this.newBaseContext + '/' + url;
            }
            return url;
        }
        return url;
    }
}

