/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import rath.msnm.AbstractProcessor;
import rath.msnm.BuddyGroup;
import rath.msnm.BuddyList;
import rath.msnm.GroupList;
import rath.msnm.MSNMessenger;
import rath.msnm.SwitchboardSession;
import rath.msnm.UserStatus;
import rath.msnm.entity.Callback;
import rath.msnm.entity.Group;
import rath.msnm.entity.MsnFriend;
import rath.msnm.entity.ServerInfo;
import rath.msnm.msg.IncomingMessage;
import rath.msnm.msg.MimeMessage;
import rath.msnm.msg.MimeUtility;
import rath.msnm.msg.OutgoingMessage;
import rath.msnm.util.StringUtil;
import rath.msnm.util.TWN;

public class NotificationProcessor
extends AbstractProcessor
implements UserStatus {
    public static final String NO_GROUP_NAME = "-- No Group --";
    public static final String NO_GROUP_IDX = "XXXX-XXXX";
    String lastFrom = "0";
    String lastTo = "0";
    String lastFN = "";
    private String securityPackage = null;
    private String status = null;
    private Thread callbackCleaner = null;
    private Hashtable lockMap = new Hashtable();
    private Hashtable sessionMap = new Hashtable();
    private HashMap callIdMap = new HashMap();
    private HashMap callingMap = new HashMap();
    private boolean isInitialRush = false;

    public NotificationProcessor(MSNMessenger msn, ServerInfo info) {
        this(msn, info, 0);
    }

    public NotificationProcessor(MSNMessenger msn, ServerInfo info, int trId) {
        super(msn, info, trId);
        this.setServerName("NS");
    }

    public void init() throws IOException {
        OutgoingMessage msg = new OutgoingMessage("VER");
        this.markTransactionId(msg);
        msg.add("MSNP10");
        msg.add("MSNP9");
        msg.add("CVRO");
        msg.setBackProcess(Callback.getInstance("processVER", this.getClass()));
        this.sendMessage(msg);
    }

    public void processMessage(IncomingMessage msg) throws Exception {
        String header = msg.getHeader();
        if (header.equals("ILN")) {
            String status = msg.get(0);
            String login = msg.get(1);
            String friendly = msg.get(2);
            MsnFriend friend = this.msn.getBuddyGroup().getForwardList().get(login);
            if (friend == null) {
                friend = new MsnFriend(login, friendly);
            } else {
                friend.setFriendlyName(friendly);
            }
            friend.setStatus(status);
            this.msn.fireListOnlineEvent(friend);
        } else if (header.equals("ADC")) {
            String group = msg.get(0);
            if (group.equals("RL") && msg.getTransactionId() == 0) {
                String login = msg.get(1);
                String friendly = msg.get(2);
                if (login.startsWith("N=")) {
                    login = login.substring(2);
                }
                if (friendly.startsWith("F=")) {
                    friendly = friendly.substring(2);
                }
                MsnFriend friend = new MsnFriend(login, friendly);
                BuddyList reverse = this.msn.getBuddyGroup().getReverseList();
                reverse.add(friend);
                this.storeLocalCopy();
                if (this.msn.getBuddyGroup().getForwardList().get(login) == null) {
                    this.msn.fireWhoAddedMeEvent(friend);
                }
            }
        } else if (header.equals("REM") && msg.getTransactionId() == 0) {
            String group = msg.get(0);
            if (group.equals("RL")) {
                String login = msg.get(1);
                BuddyList reverse = this.msn.getBuddyGroup().getReverseList();
                reverse.remove(login);
                this.storeLocalCopy();
                this.msn.fireWhoRemovedMeEvent(new MsnFriend(login, login));
            }
        } else if (header.equals("CHL")) {
            String code = StringUtil.md5(msg.get(0) + "Q1P7W2E4J9R8U3S5");
            OutgoingMessage out = new OutgoingMessage("QRY");
            this.markTransactionId(out);
            out.add("msmsgs@msnmsgr.com");
            out.add(32);
            this.sendCHLResponse(out, code);
        }
    }

    public void processNotifyMessage(IncomingMessage msg) throws Exception {
        super.processNotifyMessage(msg);
        String header = msg.getHeader();
        if (header.equals("NLN")) {
            String status = msg.get(0);
            String login = msg.get(1);
            String friendly = msg.get(2);
            BuddyList fl = this.msn.getBuddyGroup().getForwardList();
            MsnFriend friend = fl.get(login);
            if (friend != null) {
                friend.setStatus(status);
                friend.setFriendlyName(friendly);
                this.msn.fireUserOnlineEvent(friend);
            }
        } else if (header.equals("FLN")) {
            String login = msg.get(0);
            this.msn.fireUserOfflineEvent(login);
        } else if (header.equals("RNG")) {
            this.acceptRinging(msg);
        } else if (header.equals("LSG")) {
            this.doCollectGroup(msg);
        } else if (header.equals("LST")) {
            this.doCollectList(msg);
        } else if (header.equals("PRP")) {
            this.processProfile(msg);
        }
    }

    protected void processProfile(IncomingMessage msg) throws IOException {
        String head = msg.get(0);
        if (head.equals("MFN")) {
            String fn = msg.get(1);
            this.msn.getOwner().setFriendlyName(fn);
            this.msn.fireRenameNotifyEvent(this.msn.getOwner());
        }
    }

    protected void filterMimeMessage(MimeMessage msg) {
        if (msg.getKind() == 4 && msg.hasProperty("Inbox-Unread")) {
            this.msn.fireNotifyUnreadMail(msg.getProperties(), Integer.parseInt(msg.getProperty("Inbox-Unread")));
        }
    }

    protected void acceptRinging(IncomingMessage msg) throws IOException {
        String sessionId = msg.get(0);
        ServerInfo serv = msg.getServerInfo(1);
        String securityPackage = msg.get(2);
        String cookie = msg.get(3);
        String destinLoginName = msg.get(4);
        String destinFriendlyName = msg.get(5);
        SwitchboardSession ss = new SwitchboardSession(this.msn, serv, sessionId);
        ss.setCookie(cookie);
        ss.start();
    }

    public void processVER(IncomingMessage msg) throws Exception {
        OutgoingMessage out = new OutgoingMessage("CVR");
        this.markTransactionId(out);
        out.add("0x0412");
        out.add(System.getProperty("os.name").replace(' ', '_'));
        out.add(System.getProperty("os.version"));
        out.add(System.getProperty("os.arch"));
        out.add("MSNMSGR");
        out.add("6.2.0605");
        out.add("MSMSGS");
        out.add(this.msn.getLoginName());
        out.setBackProcess(Callback.getInstance("processCVR", this.getClass()));
        this.sendMessage(out);
    }

    public void processCVR(IncomingMessage msg) throws Exception {
        this.securityPackage = "TWN";
        OutgoingMessage out = new OutgoingMessage("USR");
        this.markTransactionId(out);
        out.add(this.securityPackage);
        out.add("I");
        out.add(this.msn.getLoginName());
        out.setBackProcess(Callback.getInstance("processAuth", this.getClass()));
        this.sendMessage(out);
    }

    public void processAuth(IncomingMessage msg) throws Exception {
        if (msg.getHeader().equals("XFR") && msg.get(0).equals("NS")) {
            ServerInfo info = msg.getServerInfo(1);
            this.setServerInfo(info);
            this.makeConnection();
            this.init();
            return;
        }
        OutgoingMessage out = new OutgoingMessage("USR");
        this.markTransactionId(out);
        out.add(this.securityPackage);
        out.add("S");
        if (this.securityPackage.equals("MD5")) {
            out.add(StringUtil.md5(msg.get(2) + this.msn.getPassword()));
        } else if (this.securityPackage.equals("TWN")) {
            out.add(TWN.getTNP(this.msn.getLoginName(), this.msn.getPassword(), msg.get(2)));
        }
        out.setBackProcess(Callback.getInstance("processLogon", this.getClass()));
        this.sendMessage(out);
    }

    public void processLogon(IncomingMessage msg) throws Exception {
        if (!msg.getHeader().equals("USR")) {
            this.msn.fireLoginErrorEvent(msg.getHeader());
            return;
        }
        Callback cb = Callback.getInstance("judgeSerial", this.getClass());
        OutgoingMessage out = new OutgoingMessage("SYN");
        this.markTransactionId(out);
        out.add(this.lastFrom);
        out.add(this.lastTo);
        out.setBackProcess(cb);
        this.sendMessage(out);
        this.msn.isLogged = true;
        this.msn.fireLoginCompleteEvent(new MsnFriend(msg.get(1), this.lastFN));
    }

    public void judgeSerial(IncomingMessage msg) throws IOException {
        String serverFrom = msg.get(0);
        String serverTo = msg.get(1);
        if (!serverFrom.equals(this.lastFrom) || !serverTo.equals(this.lastTo)) {
            this.lastFrom = serverFrom;
            this.lastTo = serverTo;
            BuddyGroup bg = this.msn.getBuddyGroup();
            bg.getForwardList().clear();
            bg.getAllowList().clear();
            bg.getBlockList().clear();
            bg.getReverseList().clear();
            bg.getAllList().clear();
            GroupList gl = this.msn.getBuddyGroup().getGroupList();
            gl.addGroup(new Group(NO_GROUP_NAME, NO_GROUP_IDX));
        }
        this.isInitialRush = true;
        this.setMyStatus(this.msn.getInitialStatus());
    }

    public void doCollectGroup(IncomingMessage msg) throws IOException {
        GroupList gl = this.msn.getBuddyGroup().getGroupList();
        String gName = MimeUtility.getURLDecodedString(msg.get(0), "UTF-8");
        String gIndex = msg.get(1);
        Group group = new Group(gName, gIndex);
        gl.addGroup(group);
    }

    public void doCollectList(IncomingMessage msg) throws IOException {
        String hisLoginName = msg.get(0);
        if (hisLoginName.startsWith("N=")) {
            hisLoginName = hisLoginName.substring(2);
        }
        String hisFriendlyName = null;
        String hisCode = null;
        String hisGroup = NO_GROUP_IDX;
        int accessId = 0;
        if (msg.size() < 3) {
            accessId = msg.getInt(1);
            hisFriendlyName = hisLoginName;
        } else {
            hisFriendlyName = msg.get(1);
            hisCode = msg.get(2);
            if (hisCode.startsWith("C=")) {
                accessId = msg.getInt(3);
                if (msg.size() >= 5) {
                    hisGroup = msg.get(4);
                }
                if (hisFriendlyName.startsWith("F=")) {
                    hisFriendlyName = hisFriendlyName.substring(2);
                }
                if (hisCode.startsWith("C=")) {
                    hisCode = hisCode.substring(2);
                }
            } else {
                accessId = Integer.parseInt(hisCode);
            }
        }
        BuddyGroup bg = this.msn.getBuddyGroup();
        MsnFriend friend = new MsnFriend(hisLoginName);
        friend.setFriendlyName(hisFriendlyName);
        friend.setGroupIndex(hisGroup);
        friend.setCode(hisCode);
        friend.setAccessValue(accessId);
        bg.getAllList().add(friend);
        if (BuddyGroup.isListForward(accessId)) {
            this.fixAdd(bg.getForwardList(), hisLoginName, friend, hisGroup);
        }
        if (BuddyGroup.isListAllow(accessId)) {
            this.fixAdd(bg.getAllowList(), hisLoginName, friend, hisGroup);
        }
        if (BuddyGroup.isListBlock(accessId)) {
            this.fixAdd(bg.getBlockList(), hisLoginName, friend, hisGroup);
        }
        if (BuddyGroup.isListReverse(accessId)) {
            this.fixAdd(bg.getReverseList(), hisLoginName, friend, hisGroup);
        }
        if (BuddyGroup.isNewbie(accessId)) {
            this.requestRemoveAsList(hisLoginName, "PL");
            if (!BuddyGroup.isListReverse(accessId)) {
                this.requestAddAsList(hisLoginName, "RL");
            }
            this.msn.fireWhoAddedMeEvent(friend);
        }
        if (!this.isInitialRush) {
            this.msn.fireListAdd(friend);
        }
    }

    private void fixAdd(BuddyList list, String loginName, MsnFriend friend, String groupIndex) {
        MsnFriend old = list.get(loginName);
        if (old != null) {
            friend.setStatus(old.getStatus());
        }
        list.add(friend);
        if (old != null && groupIndex != null) {
            old.setGroupIndex(groupIndex);
        }
    }

    private void collectComplete(IncomingMessage msg) throws IOException {
        this.msn.storeLocalCopy(this.lastFrom, this.lastTo);
        this.msn.fireAllListUpdatedEvent();
    }

    public void setMyStatus(String code) throws IOException {
        this.status = code;
        Callback cb = Callback.getInstance("processCHG", this.getClass());
        OutgoingMessage out = new OutgoingMessage("CHG");
        this.markTransactionId(out);
        out.add(code);
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    public void processCHG(IncomingMessage msg) throws IOException {
        if (this.isInitialRush) {
            this.isInitialRush = false;
            this.collectComplete(msg);
            Callback cb = Callback.getInstance("processCHG", this.getClass());
            OutgoingMessage out = new OutgoingMessage("CHG");
            this.markTransactionId(out);
            out.add(this.status);
            out.add("0");
            out.setBackProcess(cb);
            this.sendMessage(out);
        }
    }

    public String getMyStatus() {
        return this.status;
    }

    public void setMyFriendlyName(String newName) throws IOException {
        Callback cb = Callback.getInstance("processRename", this.getClass());
        OutgoingMessage out = new OutgoingMessage("PRP");
        this.markTransactionId(out);
        out.add("MFN");
        newName = StringUtil.replaceString(newName, "%", "%25");
        newName = StringUtil.replaceString(newName, " ", "%20");
        out.add(newName);
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    public void processRename(IncomingMessage msg) throws IOException {
        if (!msg.getHeader().equals("PRP")) {
            this.msn.fireRenameNotifyEvent(null);
            return;
        }
        String head = msg.get(0);
        String fn = msg.get(1);
        this.msn.getOwner().setFriendlyName(fn);
        this.msn.fireRenameNotifyEvent(this.msn.getOwner());
        this.storeLocalCopy();
    }

    public void start() {
        if (this.callbackCleaner == null) {
            this.startCallbackCleaner();
        }
        super.start();
    }

    private void startCallbackCleaner() {
        this.callbackCleaner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                try {
                    while (true) {
                        Thread.sleep(1800000L);
                        long limit = System.currentTimeMillis() - 300000L;
                        HashMap hashMap = NotificationProcessor.this.callbackMap;
                        synchronized (hashMap) {
                            Iterator i = NotificationProcessor.this.callbackMap.values().iterator();
                            while (i.hasNext()) {
                                Callback cb = (Callback)i.next();
                                if (cb.getCreationTime() >= limit) continue;
                                i.remove();
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    NotificationProcessor.this.processError(e);
                }
            }
        });
        this.callbackCleaner.setPriority(1);
        this.callbackCleaner.start();
    }

    public void doCallFriend(String loginName) throws IOException {
        if (this.callingMap.containsKey(loginName)) {
            return;
        }
        Callback cb = Callback.getInstance("connectToSwitchboard", this.getClass());
        OutgoingMessage out = new OutgoingMessage("XFR");
        this.markTransactionId(out);
        out.add("SB");
        out.setBackProcess(cb);
        this.callIdMap.put(new Integer(out.getTransactionId()), loginName);
        this.callingMap.put(loginName, loginName);
        this.sendMessage(out);
    }

    public void requestAdd(String loginName) throws IOException {
        this.requestAddAsList(loginName, "AL");
        this.requestAddAsList(loginName, "FL");
    }

    public void requestAddAsList(String loginName, String listKind) throws IOException, IllegalArgumentException {
        if (!(listKind.equals("AL") || listKind.equals("BL") || listKind.equals("FL") || listKind.equals("RL"))) {
            throw new IllegalArgumentException("not supported listName (AL/BL/FL/RL");
        }
        OutgoingMessage out = new OutgoingMessage("ADC");
        this.markTransactionId(out);
        out.add(listKind);
        out.add("N=" + loginName);
        if (listKind.equals("FL")) {
            out.add("F=" + loginName);
        }
        out.setBackProcess(Callback.getInstance("responseAdd", this.getClass()));
        this.sendMessage(out);
    }

    public void responseAdd(IncomingMessage msg) throws IOException {
        String header = msg.getHeader();
        if (header.equals("ADC")) {
            String code = msg.get(0);
            String loginName = msg.get(1);
            if (loginName.startsWith("N=")) {
                loginName = loginName.substring(2);
            }
            String friendlyName = loginName;
            String loginCode = null;
            if (code.equals("FL")) {
                friendlyName = msg.get(2);
                if (friendlyName.startsWith("F=")) {
                    friendlyName = friendlyName.substring(2);
                }
                if ((loginCode = msg.get(3)).startsWith("C=")) {
                    loginCode = loginCode.substring(2);
                }
            }
            MsnFriend friend = new MsnFriend(loginName, friendlyName);
            friend.setGroupIndex(NO_GROUP_IDX);
            friend.setCode(loginCode);
            BuddyList bl = this.msn.getBuddyGroup().getListAsCode(code);
            if (bl != null) {
                bl.add(friend);
            }
            this.storeLocalCopy();
        } else {
            try {
                int errorCode = Integer.parseInt(header);
                this.msn.fireAddFailedEvent(errorCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void requestRemove(String loginName) throws IOException {
        this.requestRemoveAsList(loginName, "FL");
        this.requestRemoveAsList(loginName, "AL");
    }

    public void requestRemoveAsList(String loginName, String listKind) throws IOException, IllegalArgumentException {
        this.requestRemoveAsList(loginName, listKind, false);
    }

    public void requestRemoveAsList(String loginName, String listKind, boolean isCode) throws IOException, IllegalArgumentException {
        if (!(listKind.equals("AL") || listKind.equals("BL") || listKind.equals("FL") || listKind.equals("RL") || listKind.equals("PL"))) {
            throw new IllegalArgumentException("not supported listName (AL/BL/FL/RL/PL");
        }
        OutgoingMessage out = new OutgoingMessage("REM");
        this.markTransactionId(out);
        out.add(listKind);
        if (!isCode && listKind.equals("FL")) {
            BuddyList bl = this.msn.getBuddyGroup().getListAsCode("FL");
            if (bl.get(loginName) != null) {
                out.add(bl.get(loginName).getCode());
            }
        } else {
            out.add(loginName);
        }
        out.setBackProcess(Callback.getInstance("responseRemove", this.getClass()));
        this.sendMessage(out);
    }

    public void responseRemove(IncomingMessage msg) throws IOException {
        if (msg.getHeader().equals("REM")) {
            String code = msg.get(0);
            String loginName = msg.get(1);
            BuddyList bl = this.msn.getBuddyGroup().getListAsCode(code);
            if (bl != null) {
                if (code.equals("FL")) {
                    bl.removeAsCode(loginName);
                } else {
                    bl.remove(loginName);
                }
            }
            this.storeLocalCopy();
        }
    }

    public void requestBlock(String loginName, boolean isUnblock) throws IOException {
        BuddyList fl = this.msn.getBuddyGroup().getForwardList();
        MsnFriend friend = fl.get(loginName);
        if (friend == null) {
            return;
        }
        Callback cb = Callback.getInstance("responseBlock", this.getClass());
        OutgoingMessage out = new OutgoingMessage("REM");
        this.markTransactionId(out);
        out.add(isUnblock ? "BL" : "AL");
        out.add(loginName);
        out.setBackProcess(cb);
        this.sendMessage(out);
        OutgoingMessage out2 = new OutgoingMessage("ADC");
        this.markTransactionId(out2);
        out2.add(isUnblock ? "AL" : "BL");
        out2.add("N=" + loginName);
        out2.setBackProcess(cb);
        this.sendMessage(out2);
    }

    public void responseBlock(IncomingMessage msg) throws IOException {
        BuddyList bl;
        String header = msg.getHeader();
        if (Character.isDigit(header.charAt(0))) {
            return;
        }
        String code = msg.get(0);
        String loginName = msg.get(1);
        if (loginName.startsWith("N=")) {
            loginName = loginName.substring(2);
        }
        if ((bl = this.msn.getBuddyGroup().getListAsCode(code)) != null) {
            if (header.equals("REM")) {
                bl.remove(loginName);
                this.storeLocalCopy();
            } else if (header.equals("ADC")) {
                bl.add(new MsnFriend(loginName, loginName));
                this.storeLocalCopy();
            }
        }
    }

    public void requestMoveGroup(MsnFriend friend, String oldIndex, String newIndex) throws IOException {
        Callback cb = null;
        OutgoingMessage out = null;
        if (!newIndex.equals(NO_GROUP_IDX)) {
            cb = Callback.getInstance("responseGroupAdd", this.getClass());
            out = new OutgoingMessage("ADC");
            this.markTransactionId(out);
            out.add("FL");
            out.add("C=" + friend.getCode());
            out.add(newIndex);
            out.setBackProcess(cb);
            this.sendMessage(out);
        }
        if (!oldIndex.equals(NO_GROUP_IDX)) {
            cb = Callback.getInstance("responseGroupRemove", this.getClass());
            out = new OutgoingMessage("REM");
            this.markTransactionId(out);
            out.add("FL");
            out.add(friend.getCode());
            out.add(oldIndex);
            out.setBackProcess(cb);
            this.sendMessage(out);
        }
    }

    public void responseGroupAdd(IncomingMessage msg) throws IOException {
        if (msg.size() < 3) {
            return;
        }
        String code = msg.get(0);
        String userCode = msg.get(1);
        String groupCode = msg.get(2);
        BuddyList bl = this.msn.getBuddyGroup().getListAsCode(code);
        if (bl != null) {
            if (userCode.startsWith("C=")) {
                userCode = userCode.substring(2);
            }
            MsnFriend f = bl.getAsCode(userCode);
            f.setGroupIndex(groupCode);
        }
        this.storeLocalCopy();
    }

    public void responseGroupRemove(IncomingMessage msg) throws IOException {
        if (msg.size() < 3) {
            return;
        }
        String code = msg.get(0);
        String userCode = msg.get(1);
        String groupCode = msg.get(2);
        this.storeLocalCopy();
    }

    public void requestCreateGroup(String groupName) throws IOException {
        Callback cb = Callback.getInstance("responseCreateGroup", this.getClass());
        OutgoingMessage out = new OutgoingMessage("ADG");
        this.markTransactionId(out);
        out.add(MimeUtility.getURLEncodedString(groupName, "UTF-8"));
        out.add(0);
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    public void responseCreateGroup(IncomingMessage msg) throws IOException {
        if (msg.getHeader().equals("ADG")) {
            String newName = MimeUtility.getURLDecodedString(msg.get(0), "UTF-8");
            String index = msg.get(1);
            Group group = new Group(newName, index);
            GroupList gl = this.msn.getBuddyGroup().getGroupList();
            gl.addGroup(group);
            this.storeLocalCopy();
        }
    }

    private void storeLocalCopy() {
        this.msn.storeLocalCopy(this.lastFrom, this.lastTo);
    }

    public void requestRemoveGroup(String groupIndex) throws IOException {
        Callback cb = Callback.getInstance("responseRemoveGroup", this.getClass());
        OutgoingMessage out = new OutgoingMessage("RMG");
        this.markTransactionId(out);
        out.add(groupIndex);
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    public void responseRemoveGroup(IncomingMessage msg) throws IOException {
        if (msg.getHeader().equals("RMG")) {
            String index = msg.get(0);
            GroupList gl = this.msn.getBuddyGroup().getGroupList();
            gl.removeGroup(index);
            this.storeLocalCopy();
        }
    }

    public void requestRenameGroup(String groupIndex, String newName) throws IOException {
        Callback cb = Callback.getInstance("responseRenameGroup", this.getClass());
        OutgoingMessage out = new OutgoingMessage("REG");
        this.markTransactionId(out);
        out.add(groupIndex);
        out.add(MimeUtility.getURLEncodedString(newName, "UTF-8"));
        out.setBackProcess(cb);
        this.sendMessage(out);
    }

    public void responseRenameGroup(IncomingMessage msg) throws IOException {
        if (msg.getHeader().equals("REG")) {
            GroupList gl = this.msn.getBuddyGroup().getGroupList();
            String index = msg.get(0);
            String newName = MimeUtility.getURLDecodedString(msg.get(1), "UTF-8");
            Group g = gl.getGroup(index);
            g.setName(newName);
            this.storeLocalCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchboardSession doCallFriendWait(String loginName) throws IOException, InterruptedException {
        Callback cb = Callback.getInstance("connectToSwitchboard", this.getClass());
        OutgoingMessage out = new OutgoingMessage("XFR");
        this.markTransactionId(out);
        out.add("SB");
        out.setBackProcess(cb);
        Integer tr = new Integer(out.getTransactionId());
        this.callIdMap.put(tr, loginName);
        this.sendMessage(out);
        Object lock = new Object();
        this.lockMap.put(tr, lock);
        Object object = lock;
        synchronized (object) {
            lock.wait(10000L);
        }
        return (SwitchboardSession)this.sessionMap.get(tr);
    }

    public void connectToSwitchboard(IncomingMessage msg) throws IOException {
        if (this.callIdMap.size() == 0) {
            return;
        }
        ServerInfo serv = msg.getServerInfo(1);
        if (serv == null) {
            return;
        }
        final Integer tr = new Integer(msg.getTransactionId());
        final String cookie = msg.get(3);
        final String toCallLoginName = (String)this.callIdMap.get(new Integer(msg.getTransactionId()));
        SwitchboardSession ss = new SwitchboardSession(this.msn, serv, null){
            private String firstCallName = null;
            private boolean isFirstJoin = true;

            public void init() throws IOException {
                this.firstCallName = toCallLoginName;
                Callback cb = Callback.getInstance("processUserCall", this.getClass());
                OutgoingMessage out = new OutgoingMessage("USR");
                this.markTransactionId(out);
                out.add(this.msn.getLoginName());
                out.add(cookie);
                out.setBackProcess(cb);
                this.sendMessage(out);
            }

            public void processUserCall(IncomingMessage msg) throws IOException {
                Callback cb = Callback.getInstance("processCallResult", this.getClass());
                OutgoingMessage out = new OutgoingMessage("CAL");
                this.markTransactionId(out);
                out.add(this.firstCallName);
                out.setBackProcess(cb);
                this.sendMessage(out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void processWhoJoined(IncomingMessage msg) throws Exception {
                NotificationProcessor.this.callingMap.remove(toCallLoginName);
                super.processWhoJoined(msg);
                if (this.isFirstJoin) {
                    this.isFirstJoin = false;
                    this.msn.fireSwitchboardSessionStartedEvent(this);
                    if (NotificationProcessor.this.lockMap.containsKey(tr)) {
                        NotificationProcessor.this.sessionMap.put(tr, this);
                        Object lock = NotificationProcessor.this.lockMap.remove(tr);
                        if (lock != null) {
                            Object v = lock;
                            synchronized (v) {
                                lock.notify();
                            }
                        }
                    }
                    this.sessionOpened();
                }
            }

            public void processCallResult(IncomingMessage msg) throws IOException {
                NotificationProcessor.this.callingMap.remove(toCallLoginName);
                String sessionId = msg.get(1);
                this.setSessionId(sessionId);
            }

            public void cleanUp() {
                super.cleanUp();
                NotificationProcessor.this.callingMap.remove(toCallLoginName);
                if (this.getSessionId() == null) {
                    this.msn.fireSwitchboardSessionAbandonEvent(this, this.firstCallName);
                }
            }
        };
        ss.setTarget(toCallLoginName);
        ss.start();
    }

    public void cleanUp() {
        if (this.msn.isLogged) {
            if (this.callbackCleaner != null) {
                this.callbackCleaner.interrupt();
                this.callbackCleaner = null;
            }
            this.msn.isLogged = false;
            this.msn.fireLogoutNotifyEvent();
        }
    }

    public void logout() throws IOException {
        this.cleanUp();
        this.isLive = false;
        this.setAutoOutSend(false);
        OutgoingMessage out = new OutgoingMessage("OUT");
        this.sendMessage(out);
        this.interrupt();
    }
}

