/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVLDisk {
    RowAVLDiskData currentRow;

    public RowStoreAVLDiskData(PersistentStoreCollection manager, Table table) {
        super(manager, null, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, boolean keep) {
        CachedObject cachedObject;
        this.writeLock();
        try {
            this.currentRow = (RowAVLDiskData)object;
            cachedObject = object = this.cache.get(object, (PersistentStore)this, keep);
            Object var5_4 = null;
            this.currentRow = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.currentRow = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
        return cachedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject object) {
        this.writeLock();
        try {
            int size = object.getRealSize(this.cache.rowOut);
            object.setStorageSize(size);
            this.cache.add(object);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeUnlock();
            throw throwable;
        }
        this.writeUnlock();
    }

    public CachedObject get(RowInputInterface in) {
        try {
            Object[] data = RowAVLDiskData.getRowData(this.table, in);
            if (this.currentRow == null) {
                RowAVLDiskData row = new RowAVLDiskData((PersistentStore)this, this.table, data);
                row.setPos(in.getPos());
                row.setStorageSize(in.getSize());
                row.setChanged(false);
                return row;
            }
            this.currentRow.setData(data);
            return this.currentRow;
        }
        catch (IOException e) {
            throw Error.error(484, e);
        }
    }

    public CachedObject getNewCachedObject(Session session, Object object, boolean tx) {
        RowAVLDiskData row = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(row);
        if (tx) {
            RowAction.addInsertAction(session, this.table, row);
        }
        return row;
    }

    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    public void set(CachedObject object) {
    }

    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    public void remove(int i) {
        this.cache.remove(i, this);
    }

    public void removePersistence(int i) {
        this.cache.removePersistence(i, this);
    }

    public void release(int i) {
        this.cache.release(i);
    }

    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    public void commitPersistence(CachedObject row) {
        try {
            this.cache.saveRow(row);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void commitRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                this.removePersistence(row.getPos());
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 3: {
                if (txModel == 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    public void rollbackRow(Session session, Row row, int changeAction, int txModel) {
        switch (changeAction) {
            case 2: {
                if (txModel != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (txModel != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (txModel == 0) {
                    this.remove(row.getPos());
                    break;
                }
                this.delete(session, row);
                this.remove(row.getPos());
            }
        }
    }

    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.table.database.logger.closeTextCache((Table)this.table);
        this.cache = null;
    }
}

