/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    private HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    HashMappedList tableList;
    HashMappedList sequenceList;
    long changeTimestamp;

    public Schema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.name = name;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.tableList = (HashMappedList)this.tableLookup.map;
        this.sequenceList = (HashMappedList)this.sequenceLookup.map;
        name.owner = owner;
    }

    public int getType() {
        return 2;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    public Grantee getOwner() {
        return this.name.owner;
    }

    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject parentObject) {
    }

    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.getName().statementName).append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(this.getOwner().getName().getStatementName());
        return sb.toString();
    }

    static String getSetSchemaSQL(HsqlNameManager.HsqlName schemaName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(schemaName.statementName);
        return sb.toString();
    }

    public String[] getSQLArray(OrderedHashSet resolved, OrderedHashSet unresolved) {
        HsqlArrayList list = new HsqlArrayList();
        String setSchema = Schema.getSetSchemaSQL(this.name);
        list.add(setSchema);
        Object[] subList = this.sequenceLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.tableLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.functionLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.procedureLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.assertionLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        if (list.size() == 1) {
            return new String[0];
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getSequenceRestartSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.sequenceLookup.map.values().iterator();
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            String ddl = sequence.getRestartSQL();
            list.add(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getTriggerSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.tableLookup.map.values().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Object[] ddl = table.getTriggerSQL();
            list.addAll(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void addSimpleObjects(OrderedHashSet unresolved) {
        Iterator it = this.specificRoutineLookup.map.values().iterator();
        while (it.hasNext()) {
            Routine routine = (Routine)it.next();
            if (routine.dataImpact != 1 && routine.dataImpact != 2) continue;
            unresolved.add(routine);
        }
        unresolved.addAll(this.typeLookup.map.values());
        unresolved.addAll(this.charsetLookup.map.values());
        unresolved.addAll(this.collationLookup.map.values());
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    public SchemaObjectSet getObjectSet(int type) {
        switch (type) {
            case 7: {
                return this.sequenceLookup;
            }
            case 3: 
            case 4: {
                return this.tableLookup;
            }
            case 14: {
                return this.charsetLookup;
            }
            case 15: {
                return this.collationLookup;
            }
            case 17: {
                return this.procedureLookup;
            }
            case 16: {
                return this.functionLookup;
            }
            case 18: {
                return this.functionLookup;
            }
            case 24: {
                return this.specificRoutineLookup;
            }
            case 12: 
            case 13: {
                return this.typeLookup;
            }
            case 6: {
                return this.assertionLookup;
            }
            case 8: {
                return this.triggerLookup;
            }
            case 20: {
                return this.indexLookup;
            }
            case 5: {
                return this.constraintLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    Iterator schemaObjectIterator(int type) {
        switch (type) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator functions = this.functionLookup.map.values().iterator();
                return new WrapperIterator(functions, this.procedureLookup.map.values().iterator());
            }
            case 24: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    void clearStructures() {
        this.tableList.clear();
        this.sequenceList.clear();
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
    }
}

