/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.html;

import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.html.HtmlHelper;
import org.apache.abdera.ext.html.HtmlParserOptions;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.util.AbstractNamedParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParser
extends AbstractNamedParser {
    public HtmlParser() {
        this(null);
    }

    public HtmlParser(Abdera abdera) {
        super(abdera, "html", new String[0]);
    }

    @Override
    protected ParserOptions initDefaultParserOptions() {
        return new HtmlParserOptions();
    }

    @Override
    public <T extends Element> Document<T> parse(Reader in, String base, ParserOptions options) throws ParseException {
        boolean fragment = options instanceof HtmlParserOptions ? ((HtmlParserOptions)options).isHtmlFragment() : false;
        Document<Element> doc = null;
        if (fragment) {
            Div div = HtmlHelper.parse(this.abdera, in);
            doc = this.getFactory().newDocument();
            doc.setRoot(div);
        } else {
            doc = HtmlHelper.parseDocument(this.abdera, in);
        }
        if (base != null) {
            doc.setBaseUri(base);
        }
        return doc;
    }

    @Override
    public <T extends Element> Document<T> parse(XMLStreamReader reader) throws ParseException {
        return null;
    }

    @Override
    public <T extends Element> Document<T> parse(XMLStreamReader reader, String base, ParserOptions options) throws ParseException {
        return null;
    }
}

