/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.shopping.CartMinQuantityException;
import com.liferay.portlet.shopping.CouponActiveException;
import com.liferay.portlet.shopping.CouponEndDateException;
import com.liferay.portlet.shopping.CouponStartDateException;
import com.liferay.portlet.shopping.NoSuchCouponException;
import com.liferay.portlet.shopping.model.ShoppingCart;
import com.liferay.portlet.shopping.model.ShoppingCartItem;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingCoupon;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.impl.ShoppingCartItemImpl;
import com.liferay.portlet.shopping.service.base.ShoppingCartLocalServiceBaseImpl;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ShoppingCartLocalServiceImpl
extends ShoppingCartLocalServiceBaseImpl {
    public void deleteGroupCarts(long groupId) throws SystemException {
        List carts = this.shoppingCartPersistence.findByGroupId(groupId);
        for (ShoppingCart cart : carts) {
            this.deleteShoppingCart(cart);
        }
    }

    public void deleteUserCarts(long userId) throws SystemException {
        List shoppingCarts = this.shoppingCartPersistence.findByUserId(userId);
        for (ShoppingCart shoppingCart : shoppingCarts) {
            this.deleteShoppingCart(shoppingCart);
        }
    }

    public ShoppingCart getCart(long userId, long groupId) throws PortalException, SystemException {
        return this.shoppingCartPersistence.findByG_U(groupId, userId);
    }

    public Map<ShoppingCartItem, Integer> getItems(long groupId, String itemIds) throws SystemException {
        TreeMap<ShoppingCartItem, Integer> items = new TreeMap<ShoppingCartItem, Integer>();
        String[] itemIdsArray = StringUtil.split((String)itemIds);
        int i2 = 0;
        while (i2 < itemIdsArray.length) {
            ShoppingCategory category;
            long itemId = ShoppingUtil.getItemId(itemIdsArray[i2]);
            String fields = ShoppingUtil.getItemFields(itemIdsArray[i2]);
            ShoppingItem item = this.shoppingItemPersistence.fetchByPrimaryKey(itemId);
            if (item != null && (category = item.getCategory()).getGroupId() == groupId) {
                ShoppingCartItemImpl cartItem = new ShoppingCartItemImpl(item, fields);
                Integer count = (Integer)items.get(cartItem);
                count = count == null ? new Integer(1) : new Integer(count + 1);
                items.put(cartItem, count);
            }
            ++i2;
        }
        return items;
    }

    public ShoppingCart updateCart(long userId, long groupId, String itemIds, String couponCodes, int altShipping, boolean insure) throws PortalException, SystemException {
        ArrayList<Long> badItemIds = new ArrayList<Long>();
        Map<ShoppingCartItem, Integer> items = this.getItems(groupId, itemIds);
        boolean minQtyMultiple = GetterUtil.getBoolean((String)PropsUtil.get("shopping.cart.min.qty.multiple"));
        for (Map.Entry<ShoppingCartItem, Integer> entry : items.entrySet()) {
            ShoppingCartItem cartItem = entry.getKey();
            Integer count = entry.getValue();
            ShoppingItem item = cartItem.getItem();
            int minQuantity = ShoppingUtil.getMinQuantity(item);
            if (minQuantity <= 0) continue;
            if (minQtyMultiple) {
                if (count % minQuantity <= 0) continue;
                badItemIds.add(item.getItemId());
                continue;
            }
            if (count >= minQuantity) continue;
            badItemIds.add(item.getItemId());
        }
        if (badItemIds.size() > 0) {
            throw new CartMinQuantityException(StringUtil.merge((Object[])badItemIds.toArray(new Long[badItemIds.size()])));
        }
        int i2 = 0;
        String[] couponCodesArray = StringUtil.split((String)couponCodes);
        if (i2 < couponCodesArray.length) {
            try {
                ShoppingCoupon coupon = this.shoppingCouponPersistence.findByCode(couponCodesArray[i2]);
                if (coupon.getGroupId() != groupId) {
                    throw new NoSuchCouponException(couponCodesArray[i2]);
                }
                if (!coupon.isActive()) {
                    throw new CouponActiveException(couponCodesArray[i2]);
                }
                if (!coupon.hasValidStartDate()) {
                    throw new CouponStartDateException(couponCodesArray[i2]);
                }
                if (!coupon.hasValidEndDate()) {
                    throw new CouponEndDateException(couponCodesArray[i2]);
                }
            }
            catch (NoSuchCouponException noSuchCouponException) {
                throw new NoSuchCouponException(couponCodesArray[i2]);
            }
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        ShoppingCart cart = null;
        if (user.isDefaultUser()) {
            cart = this.shoppingCartPersistence.create(0L);
            cart.setGroupId(groupId);
            cart.setCompanyId(user.getCompanyId());
            cart.setUserId(userId);
            cart.setUserName(user.getFullName());
            cart.setCreateDate(now);
        } else {
            cart = this.shoppingCartPersistence.fetchByG_U(groupId, userId);
            if (cart == null) {
                long cartId = this.counterLocalService.increment();
                cart = this.shoppingCartPersistence.create(cartId);
                cart.setGroupId(groupId);
                cart.setCompanyId(user.getCompanyId());
                cart.setUserId(userId);
                cart.setUserName(user.getFullName());
                cart.setCreateDate(now);
            }
        }
        cart.setModifiedDate(now);
        cart.setItemIds(this.checkItemIds(groupId, itemIds));
        cart.setCouponCodes(couponCodes);
        cart.setAltShipping(altShipping);
        cart.setInsure(insure);
        if (!user.isDefaultUser()) {
            this.shoppingCartPersistence.update((BaseModel)cart);
        }
        return cart;
    }

    protected String checkItemIds(long groupId, String itemIds) {
        String[] itemIdsArray = StringUtil.split((String)itemIds);
        int i2 = 0;
        while (i2 < itemIdsArray.length) {
            long itemId = ShoppingUtil.getItemId(itemIdsArray[i2]);
            ShoppingItem item = null;
            try {
                item = this.shoppingItemPersistence.findByPrimaryKey(itemId);
                ShoppingCategory category = item.getCategory();
                if (category.getGroupId() != groupId) {
                    item = null;
                }
            }
            catch (Exception exception) {}
            if (item == null) {
                itemIds = StringUtil.remove((String)itemIds, (String)itemIdsArray[i2]);
            }
            ++i2;
        }
        return itemIds;
    }
}

