/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletdisplaytemplate.webdav;

import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.webdav.DDMWebDavUtil;
import java.util.ArrayList;
import java.util.List;

public class ApplicationDisplayTemplateWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.deleteResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.getResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                return this.getFolders(webDAVRequest);
            }
            if (pathArray.length == 3) {
                return this.getTemplates(webDAVRequest);
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return DDMWebDavUtil.putResource(webDAVRequest, this.getRootPath(), this.getToken(), 0L);
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(DDMWebDavUtil.toResource(webDAVRequest, "Templates", this.getRootPath(), true));
        return resources;
    }

    protected List<Resource> getTemplates(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmTemplates = DDMTemplateLocalServiceUtil.getTemplatesByClassPK((long)webDAVRequest.getGroupId(), (long)0L);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            Resource resource = DDMWebDavUtil.toResource(webDAVRequest, ddmTemplate, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }
}

