/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.spring.transaction.TransactionExecutor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class TransactionalCallableUtil {
    private static PlatformTransactionManager _platformTransactionManager;
    private static TransactionExecutor _transactionExecutor;

    public static <T> T call(TransactionAttribute transactionAttribute, Callable<T> callable) throws Throwable {
        return (T)_transactionExecutor.execute(_platformTransactionManager, transactionAttribute, new CallableMethodInvocation(callable));
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        _platformTransactionManager = platformTransactionManager;
    }

    public void setTransactionExecutor(TransactionExecutor transactionExecutor) {
        _transactionExecutor = transactionExecutor;
    }

    private static class CallableMethodInvocation
    implements MethodInvocation {
        private Callable<?> _callable;

        private CallableMethodInvocation(Callable<?> callable) {
            this._callable = callable;
        }

        public Object[] getArguments() {
            throw new UnsupportedOperationException();
        }

        public Method getMethod() {
            throw new UnsupportedOperationException();
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            throw new UnsupportedOperationException();
        }

        public Object proceed() throws Throwable {
            return this._callable.call();
        }
    }
}

