/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.googleapps.GAuthenticator;
import com.liferay.portal.googleapps.GBaseManagerImpl;
import com.liferay.portal.googleapps.GetNextItems;
import com.liferay.portal.googleapps.GoogleApps;
import com.liferay.portal.kernel.googleapps.GNickname;
import com.liferay.portal.kernel.googleapps.GNicknameManager;
import com.liferay.portal.kernel.googleapps.GUser;
import com.liferay.portal.kernel.googleapps.GUserManager;
import com.liferay.portal.kernel.googleapps.GoogleAppsException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class GUserManagerImpl
extends GBaseManagerImpl
implements GUserManager {
    protected String userURL;
    private static Log _log = LogFactoryUtil.getLog(GUserManagerImpl.class);

    public GUserManagerImpl(GoogleApps googleApps) {
        super(googleApps);
        GAuthenticator gAuthenticator = googleApps.getGAuthenticator();
        StringBundler sb = new StringBundler(4);
        sb.append("https://apps-apis.google.com/a/feeds");
        sb.append("/");
        sb.append(gAuthenticator.getDomain());
        sb.append("/user/2.0");
        this.userURL = sb.toString();
    }

    public void addGUser(long userId, String password, String firstName, String lastName) throws GoogleAppsException {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntryElement = this.addAtomEntry(document);
        this.addAtomCategory(atomEntryElement, "user");
        Element appsLoginElement = atomEntryElement.addElement("apps:login");
        appsLoginElement.addAttribute("password", password);
        appsLoginElement.addAttribute("userName", String.valueOf(userId));
        Element appsNameElement = atomEntryElement.addElement("apps:name");
        appsNameElement.addAttribute("familyName", lastName);
        appsNameElement.addAttribute("givenName", firstName);
        this.submitAdd(this.userURL, document);
    }

    public void deleteGUser(long userId) throws GoogleAppsException {
        this.submitDelete(this.getUserURL(userId));
    }

    public GUser getGUser(long userId) throws GoogleAppsException {
        Document document = this.getDocument(this.getUserURL(userId));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return null;
        }
        Element atomEntryElement = document.getRootElement();
        return this.getGUser(atomEntryElement);
    }

    public GUser getGUser(String emailAddress) throws GoogleAppsException {
        int pos = emailAddress.indexOf(64);
        if (pos == -1) {
            return null;
        }
        String nickname = emailAddress.substring(0, pos);
        if (Validator.isNumber((String)nickname)) {
            long userId = GetterUtil.getLong((String)nickname);
            return this.getGUser(userId);
        }
        try {
            User user = UserLocalServiceUtil.getUserByEmailAddress((long)this.getCompanyId(), (String)emailAddress);
            return this.getGUser(user.getUserId());
        }
        catch (Exception exception) {
            GNicknameManager gNicknameManager = this.googleApps.getGNicknameManager();
            GNickname gNickname = gNicknameManager.getGNickname(nickname);
            if (gNickname != null) {
                return this.getGUser(gNickname.getUserId());
            }
            return null;
        }
    }

    public List<GUser> getGUsers() throws GoogleAppsException {
        ArrayList<GUser> gUsers = new ArrayList<GUser>();
        this.getGUsers(gUsers, this.userURL);
        return gUsers;
    }

    public void updateActive(long userId, boolean active) throws GoogleAppsException {
        Document document = this.getDocument(this.getUserURL(userId));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return;
        }
        Element atomEntryElement = document.getRootElement();
        Element appsLoginElement = atomEntryElement.element(this.getAppsQName("login"));
        appsLoginElement.addAttribute("suspended", String.valueOf(!active));
        this.submitUpdate(this.getUserURL(userId), document);
    }

    public void updatePassword(long userId, String password) throws GoogleAppsException {
        Document document = this.getDocument(this.getUserURL(userId));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return;
        }
        Element atomEntryElement = document.getRootElement();
        Element appsLoginElement = atomEntryElement.element(this.getAppsQName("login"));
        appsLoginElement.addAttribute("password", password);
        this.submitUpdate(this.getUserURL(userId), document);
    }

    protected GUser getGUser(Element atomEntryElement) {
        GUser gUser = new GUser();
        Element appsLoginElement = atomEntryElement.element(this.getAppsQName("login"));
        Element appsNameElement = atomEntryElement.element(this.getAppsQName("name"));
        boolean active = !GetterUtil.getBoolean((String)appsLoginElement.attributeValue("suspended"));
        gUser.setActive(active);
        boolean administrator = GetterUtil.getBoolean((String)appsLoginElement.attributeValue("admin"));
        gUser.setAdministrator(administrator);
        boolean agreedToTermsOfUse = GetterUtil.getBoolean((String)appsLoginElement.attributeValue("agreedToTerms"));
        gUser.setAgreedToTermsOfUse(agreedToTermsOfUse);
        String firstName = appsNameElement.attributeValue("givenName");
        gUser.setFirstName(firstName);
        String lastName = appsNameElement.attributeValue("familyName");
        gUser.setLastName(lastName);
        long userId = GetterUtil.getLong((String)appsLoginElement.attributeValue("userName"));
        gUser.setUserId(userId);
        return gUser;
    }

    protected void getGUsers(final List<GUser> gUsers, String url) throws GoogleAppsException {
        Document document = this.getDocument(url);
        Element atomFeedElement = document.getRootElement();
        List atomEntryElements = atomFeedElement.elements(this.getAtomQName("entry"));
        for (Element atomEntryElement : atomEntryElements) {
            GUser gUser = this.getGUser(atomEntryElement);
            gUsers.add(gUser);
        }
        new GetNextItems(url, atomFeedElement){

            @Override
            public void getNextItems(String nextURL) throws GoogleAppsException {
                GUserManagerImpl.this.getGUsers(gUsers, nextURL);
            }
        };
    }

    protected String getUserURL(long userId) {
        return this.userURL.concat("/").concat(String.valueOf(userId));
    }
}

