/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.multipart;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.filter.ActionRequestWrapper;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultipartActionRequest
extends ActionRequestWrapper
implements MultipartActionRequest {
    private MultiValueMap<String, MultipartFile> multipartFiles;
    private Map<String, String[]> multipartParameters;

    public DefaultMultipartActionRequest(ActionRequest request, MultiValueMap<String, MultipartFile> mpFiles, Map<String, String[]> mpParams) {
        super(request);
        this.setMultipartFiles(mpFiles);
        this.setMultipartParameters(mpParams);
    }

    protected DefaultMultipartActionRequest(ActionRequest request) {
        super(request);
    }

    public Iterator<String> getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.getMultipartFiles().getFirst((Object)name);
    }

    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.getMultipartFiles().get((Object)name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    public Map<String, MultipartFile> getFileMap() {
        return this.getMultipartFiles().toSingleValueMap();
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return this.getMultipartFiles();
    }

    public Enumeration<String> getParameterNames() {
        HashSet<String> paramNames = new HashSet<String>();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add((String)paramEnum.nextElement());
        }
        paramNames.addAll((Collection)this.getMultipartParameters().keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = this.getMultipartParameters().get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = this.getMultipartParameters().get(name);
        if (values != null) {
            return values;
        }
        return super.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.getMultipartParameters());
        return paramMap;
    }

    protected final void setMultipartFiles(MultiValueMap<String, MultipartFile> multipartFiles) {
        this.multipartFiles = new LinkedMultiValueMap(Collections.unmodifiableMap(multipartFiles));
    }

    protected MultiValueMap<String, MultipartFile> getMultipartFiles() {
        if (this.multipartFiles == null) {
            this.initializeMultipart();
        }
        return this.multipartFiles;
    }

    protected final void setMultipartParameters(Map<String, String[]> multipartParameters) {
        this.multipartParameters = multipartParameters;
    }

    protected Map<String, String[]> getMultipartParameters() {
        if (this.multipartParameters == null) {
            this.initializeMultipart();
        }
        return this.multipartParameters;
    }

    protected void initializeMultipart() {
        throw new IllegalStateException("Multipart request not initialized");
    }
}

