/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class SPIConfiguration
implements Serializable {
    public static final String JAVA_EXECUTABLE_DEFAULT = "java";
    public static final String JVM_ARGUMENTS_DEFAULT = "-Xmx1024m -XX:PermSize=200m";
    public static final long PING_INTERVAL_DEFAULT = 5000L;
    public static final long REGISTER_TIMEOUT_DEFAULT = 10000L;
    public static final long SHUTDOWN_TIMEOUT_DEFAULT = 10000L;
    private static final long serialVersionUID = 1L;
    private String _baseDir;
    private int _connectorPort;
    private String _extraSettings;
    private String _javaExecutable;
    private String _jvmArguments;
    private long _pingInterval;
    private String[] _portletIds;
    private long _registerTimeout;
    private String[] _servletContextNames;
    private long _shutdownTimeout;
    private String _spiAgentClassName;
    private String _spiId;

    public static SPIConfiguration fromXMLString(String xmlString) throws DocumentException {
        Document document = UnsecureSAXReaderUtil.read(xmlString);
        Element rootElement = document.getRootElement();
        String id = rootElement.elementText("id");
        String javaExecutable = rootElement.elementText("javaExecutable");
        String jvmArguments = rootElement.elementText("jvmArguments");
        String spiAgentClassName = rootElement.elementText("spiAgentClassName");
        int connectorPort = GetterUtil.getIntegerStrict(rootElement.elementText("connectorPort"));
        String baseDir = rootElement.elementText("baseDir");
        String[] portletIds = StringUtil.split(rootElement.elementText("portletIds"));
        String[] servletContextNames = StringUtil.split(rootElement.elementText("servletContextNames"));
        long pingInterval = GetterUtil.getLongStrict(rootElement.elementText("pingInterval"));
        long registerTimeout = GetterUtil.getLongStrict(rootElement.elementText("registerTimeout"));
        long shutdownTimeout = GetterUtil.getLongStrict(rootElement.elementText("shutdownTimeout"));
        String extraSettings = rootElement.elementText("extraSettings");
        return new SPIConfiguration(id, javaExecutable, jvmArguments, spiAgentClassName, connectorPort, baseDir, portletIds, servletContextNames, pingInterval, registerTimeout, shutdownTimeout, extraSettings);
    }

    public SPIConfiguration(String spiId, String spiAgentClassName, int connectorPort, String baseDir, String[] portletIds, String[] servletContextNames, String extraSettings) {
        this(spiId, JAVA_EXECUTABLE_DEFAULT, JVM_ARGUMENTS_DEFAULT, spiAgentClassName, connectorPort, baseDir, portletIds, servletContextNames, 5000L, 10000L, 10000L, extraSettings);
    }

    public SPIConfiguration(String spiId, String javaExecutable, String jvmArguments, String spiAgentClassName, int connectorPort, String baseDir, String[] portletIds, String[] servletContextNames, long pingInterval, long registerTimeout, long shutdownTimeout, String extraSettings) {
        this._spiId = spiId;
        this._javaExecutable = javaExecutable;
        this._jvmArguments = jvmArguments;
        this._spiAgentClassName = spiAgentClassName;
        this._connectorPort = connectorPort;
        this._baseDir = baseDir;
        this._portletIds = portletIds;
        this._servletContextNames = servletContextNames;
        this._pingInterval = pingInterval;
        this._registerTimeout = registerTimeout;
        this._shutdownTimeout = shutdownTimeout;
        this._extraSettings = extraSettings;
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public int getConnectorPort() {
        return this._connectorPort;
    }

    public String getExtraSettings() {
        return this._extraSettings;
    }

    public String getJavaExecutable() {
        return this._javaExecutable;
    }

    public List<String> getJVMArguments() {
        return Arrays.asList(StringUtil.split(this._jvmArguments, ' '));
    }

    public long getPingInterval() {
        return this._pingInterval;
    }

    public String[] getPortletIds() {
        return this._portletIds;
    }

    public long getRegisterTimeout() {
        return this._registerTimeout;
    }

    public String[] getServletContextNames() {
        return this._servletContextNames;
    }

    public long getShutdownTimeout() {
        return this._shutdownTimeout;
    }

    public String getSPIAgentClassName() {
        return this._spiAgentClassName;
    }

    public String getSPIId() {
        return this._spiId;
    }

    public String toString() {
        StringBundler sb = new StringBundler(25);
        sb.append("{baseDir=");
        sb.append(this._baseDir);
        sb.append(", connectorPort=");
        sb.append(this._connectorPort);
        sb.append(", extraSettings=");
        sb.append(this._extraSettings);
        sb.append(", javaExecutable=");
        sb.append(this._javaExecutable);
        sb.append(", jvmArguments=");
        sb.append(this._jvmArguments);
        sb.append(", pingInterval=");
        sb.append(this._pingInterval);
        sb.append(", portletIds=[");
        sb.append(StringUtil.merge(this._portletIds));
        sb.append("], registerTimeout=");
        sb.append(this._registerTimeout);
        sb.append(", servletContextName=[");
        sb.append(StringUtil.merge(this._servletContextNames));
        sb.append("], shutdownTimeout=");
        sb.append(this._shutdownTimeout);
        sb.append(", spiAgentClassName=");
        sb.append(this._spiAgentClassName);
        sb.append(", spiId=");
        sb.append(this._spiId);
        sb.append("}");
        return sb.toString();
    }

    public String toXMLString() {
        com.liferay.portal.kernel.xml.simple.Element element = new com.liferay.portal.kernel.xml.simple.Element("SPIConfiguration");
        element.addElement("id", this._spiId);
        element.addElement("javaExecutable", this._javaExecutable);
        element.addElement("jvmArguments", this._jvmArguments);
        element.addElement("spiAgentClassName", this._spiAgentClassName);
        element.addElement("connectorPort", this._connectorPort);
        element.addElement("baseDir", this._baseDir);
        element.addElement("portletIds", StringUtil.merge(this._portletIds));
        element.addElement("servletContextNames", StringUtil.merge(this._servletContextNames));
        element.addElement("pingInterval", this._pingInterval);
        element.addElement("registerTimeout", this._registerTimeout);
        element.addElement("shutdownTimeout", this._shutdownTimeout);
        element.addElement("extraSettings", this._extraSettings);
        return element.toXMLString();
    }
}

