/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;

public class ClusterLinkUtil {
    public static final String CLUSTER_FORWARD_MESSAGE = "CLUSTER_FORWARD_MESSAGE";
    private static final String _ADDRESS = "CLUSTER_ADDRESS";
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkUtil.class);
    private static ClusterLink _clusterLink;

    public static Address getAddress(Message message) {
        return (Address)message.get(_ADDRESS);
    }

    public static InetAddress getBindInetAddress() {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return null;
        }
        return clusterLink.getBindInetAddress();
    }

    public static ClusterLink getClusterLink() {
        PortalRuntimePermission.checkGetBeanProperty(ClusterLinkUtil.class);
        if (_clusterLink == null || !_clusterLink.isEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn("ClusterLinkUtil has not been initialized");
            }
            return null;
        }
        return _clusterLink;
    }

    public static List<Address> getLocalTransportAddresses() {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return Collections.emptyList();
        }
        return clusterLink.getLocalTransportAddresses();
    }

    public static List<Address> getTransportAddresses(Priority priority) {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return Collections.emptyList();
        }
        return clusterLink.getTransportAddresses(priority);
    }

    public static void initialize() {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return;
        }
        clusterLink.initialize();
    }

    public static boolean isForwardMessage(Message message) {
        return message.getBoolean(CLUSTER_FORWARD_MESSAGE);
    }

    public static void sendMulticastMessage(Message message, Priority priority) {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return;
        }
        clusterLink.sendMulticastMessage(message, priority);
    }

    public static void sendMulticastMessage(Object payload, Priority priority) {
        Message message = new Message();
        message.setPayload(payload);
        ClusterLinkUtil.sendMulticastMessage(message, priority);
    }

    public static void sendUnicastMessage(Address address, Message message, Priority priority) {
        ClusterLink clusterLink = ClusterLinkUtil.getClusterLink();
        if (clusterLink == null) {
            return;
        }
        clusterLink.sendUnicastMessage(address, message, priority);
    }

    public static Message setAddress(Message message, Address address) {
        message.put(_ADDRESS, address);
        return message;
    }

    public static void setForwardMessage(Message message) {
        message.put(CLUSTER_FORWARD_MESSAGE, true);
    }

    public void setClusterLink(ClusterLink clusterLink) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _clusterLink = clusterLink;
    }
}

