/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ReaderFileMediationThread
extends Thread {
    private URI locator = null;
    private int readCount;
    private String storeBase;
    private boolean doStore = false;
    private int readerID = 0;

    public ReaderFileMediationThread(URI locator, int readCount, String storeBase, boolean doStore, int readerID) {
        this.locator = locator;
        this.readCount = readCount;
        this.storeBase = storeBase;
        this.doStore = doStore;
        this.readerID = readerID;
    }

    @Override
    public void run() {
        try {
            ForwardReader reader = new ForwardReader(this.locator);
            reader.setIteratorTimeout(600L);
            reader.setIteratorTimeUnit(TimeUnit.SECONDS);
            System.out.println("starting reading");
            int count = 0;
            Iterator iter = reader.iterator();
            while (true) {
                BufferedInputStream bin;
                long startRec = System.currentTimeMillis();
                if (!iter.hasNext()) {
                    System.out.println("no more after " + (System.currentTimeMillis() - startRec));
                    break;
                }
                if (count == this.readCount) break;
                GenericRecord rec = (GenericRecord)iter.next();
                long endRec = System.currentTimeMillis();
                if (rec == null) {
                    throw new TimeoutException("timeout while waiting for next");
                }
                ++count;
                Field f = rec.getField("FileField");
                long startMed = System.currentTimeMillis();
                if (this.doStore) {
                    int read;
                    bin = new BufferedInputStream(f.getMediatingInputStream());
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(new File(this.storeBase, UUID.randomUUID().toString())));
                    byte[] buf = new byte[4096];
                    while ((read = bin.read(buf)) >= 0) {
                        bout.write(buf, 0, read);
                    }
                    bout.flush();
                    bout.close();
                    bin.close();
                } else {
                    int read;
                    bin = new BufferedInputStream(f.getMediatingInputStream());
                    byte[] buf = new byte[4096];
                    while ((read = bin.read(buf)) >= 0) {
                    }
                    bin.close();
                }
                System.out.println(this.readerID + " - " + ((FileField)f).getPayload().toString() + " in " + (endRec - startRec) + " with available " + reader.availableRecords() + " and total " + reader.totalRecords() + " mediation took " + (System.currentTimeMillis() - startMed));
            }
            System.out.println("read total " + count);
            System.out.println("reader closing");
            Thread.sleep(10000L);
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

