/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import java.io.StringWriter;
import java.io.Writer;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryServicePublisherHandler;

public class CreateResourceHandler
extends BaseISPublisherHandler {
    protected static final GCUBELog logger = new GCUBELog(CreateResourceHandler.class);
    private GCUBEScope scope;
    private ISRegistryClient registryClient;
    private final GCUBEResource profile;

    public CreateResourceHandler(GCUBEScope scope, ISRegistryClient registryClient, GCUBEResource profile) {
        this.scope = scope;
        this.registryClient = registryClient;
        this.profile = profile;
    }

    @Override
    public String getResourceID() {
        return this.profile.getID();
    }

    @Override
    protected void submitRequest() throws Exception {
        this.registryClient.setScope(this.scope);
        try {
            ISRegistryServicePublisherHandler registryHandler = new ISRegistryServicePublisherHandler();
            registryHandler.setResourceType(this.profile.getType());
            registryHandler.setResourceID(this.profile.getID());
            StringWriter writer = new StringWriter();
            this.profile.store((Writer)writer);
            registryHandler.setProfile(writer.toString());
            registryHandler.setHandled((Object)this.registryClient);
            registryHandler.run();
            logger.trace((Object)("Resource with ID=" + this.profile.getID() + " successfully published"));
            return;
        }
        catch (GCUBEUnrecoverableException e) {
            logger.warn((Object)"Registration failed", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.warn((Object)"Registration failed, trying again in a few time...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }
}

