/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.SMSPortType1PortType;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSInputStream;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.util.SMSContentUtil;

public class SMSURLConnection
extends URLConnection {
    public static final String SMS_PROTOCOL_NAME = "sms";
    protected static final int CACHE_LIMIT = 10;
    protected static GCUBEScopeManager scopeManager;
    protected static Map<GCUBEScope, SMSPortType1PortType> ppCache;
    protected Logger logger = Logger.getLogger(SMSURLConnection.class);
    protected SMSPortType1PortType sms;
    protected String oid;
    protected GCUBEScope scope;

    public static String getOIDUrl(String oid) {
        StringBuilder sb = new StringBuilder(SMS_PROTOCOL_NAME);
        sb.append("://");
        sb.append(oid);
        return sb.toString();
    }

    @Deprecated
    public static URLConnection openConnection(URI uri, String scope) throws IOException, URISyntaxException {
        URLConnection connection = uri.toURL().openConnection();
        connection.setRequestProperty("scope", scope);
        return connection;
    }

    public static URLConnection openConnection(URI uri) throws IOException, URISyntaxException {
        URLConnection connection = uri.toURL().openConnection();
        return connection;
    }

    @Deprecated
    public static void setScopeManager(GCUBEScopeManager sm) {
        scopeManager = sm;
    }

    public SMSURLConnection(URL url) throws IOException {
        super(url);
        this.logger.setLevel(Level.ALL);
        this.logger.trace((Object)("Initializing SMSURLConnection with url: " + url));
    }

    @Override
    @Deprecated
    public void setRequestProperty(String key, String value) {
        super.setRequestProperty(key, value);
        if (key.equals("scope")) {
            try {
                this.scope = GCUBEScope.getScope((String)value);
            }
            catch (GCUBEScope.MalformedScopeExpressionException malformedScopeExpressionException) {
                // empty catch block
            }
        }
    }

    public static void activateProtocol() {
        String pkgs_name = "java.protocol.handler.pkgs";
        String pkgs = System.getProperty(pkgs_name);
        String pkg = "org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol";
        if (pkgs == null) {
            pkgs = pkg;
        } else if (!pkgs.contains(pkg)) {
            pkgs = pkgs + "|" + pkg;
        }
        System.setProperty(pkgs_name, pkgs);
    }

    @Override
    public synchronized void connect() throws IOException {
        this.oid = this.url.getAuthority();
        this.logger.trace((Object)("OID: " + this.oid));
        this.logger.trace((Object)("scope: " + this.scope));
        if (this.scope == null && scopeManager != null) {
            this.scope = scopeManager.getScope();
        }
        if (this.scope == null) {
            this.scope = GCUBEScopeManager.DEFAULT.getScope();
        }
        if (this.scope != null) {
            try {
                this.sms = this.getSMSPortType(this.scope);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error retrieving the storage management instance", (Throwable)e);
                throw new IOException("Error retrieving the storage management instance", e);
            }
            boolean exists = this.sms.existsInfoObject(this.oid);
            this.logger.trace((Object)("oid exists? " + exists));
            if (!exists) {
                this.logger.error((Object)("The specified oid \"" + this.oid + "\"don't exists on the SMS."));
                throw new IOException("The specified oid \"" + this.oid + "\"don't exists on the SMS.");
            }
        } else {
            this.logger.error((Object)"No working scope found");
            throw new IOException("No working scope found.");
        }
    }

    protected SMSPortType1PortType getSMSPortType(GCUBEScope scope) throws Exception {
        SMSPortType1PortType portType = ppCache.get(scope);
        if (portType != null) {
            return portType;
        }
        portType = SMSContentUtil.getStorageManagementPortType1(scope, null);
        ppCache.put(scope, portType);
        return portType;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new BufferedInputStream(new SMSInputStream(this.sms, this.oid));
    }

    static {
        ppCache = new LinkedHashMap<GCUBEScope, SMSPortType1PortType>(16, 0.75f, true){
            private static final long serialVersionUID = -1643057005108494175L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<GCUBEScope, SMSPortType1PortType> eldest) {
                return this.size() > 10;
            }
        };
    }
}

