/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.http.HTTPConnectionManager;
import gr.uoa.di.madgik.commons.server.http.IHTTPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.http.HTTPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.http.HTTPStoreWriterProxy;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalStoreWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.test.ReaderFileMediationThread;
import gr.uoa.di.madgik.grs.test.ReaderFileThread;
import gr.uoa.di.madgik.grs.test.ReaderForeachThread;
import gr.uoa.di.madgik.grs.test.ReaderFullThread;
import gr.uoa.di.madgik.grs.test.ReaderIteratorThread;
import gr.uoa.di.madgik.grs.test.ReaderObjectThread;
import gr.uoa.di.madgik.grs.test.ReaderRandomIteratorThread;
import gr.uoa.di.madgik.grs.test.ReaderRandomThread;
import gr.uoa.di.madgik.grs.test.ReaderURLThread;
import gr.uoa.di.madgik.grs.test.WriterFileThread;
import gr.uoa.di.madgik.grs.test.WriterMultiFieldThread;
import gr.uoa.di.madgik.grs.test.WriterObjectThread;
import gr.uoa.di.madgik.grs.test.WriterSimpleThread;
import gr.uoa.di.madgik.grs.test.WriterURLThread;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class MainTest {
    private static IProxy.ProxyType pType = IProxy.ProxyType.HTTP;
    private static TestType tType = TestType.string_random_test;
    private static int WriterPremature = -1;
    private static int ReaderPremature = -1;
    private static int WriterItems = 50000;
    private static boolean DoCompress = false;
    private static IBuffer.TransportDirective FileTransportDirective = IBuffer.TransportDirective.Full;
    private static int Capacity = 10;
    private static String StoreBase = "/home/nikolas/Desktop/testData";
    private static boolean DoStore = true;
    private static boolean sendEvents = true;
    private static IBufferStore.MultiplexType Multiplex = IBufferStore.MultiplexType.FIFO;
    private static String TestFileName = "/home/nikolas/Desktop/AliceWonderland.txt";
    private static String TestURI = "http://www.google.com";

    private static URI toStore(URI[] locators, IBufferStore.MultiplexType multiplex, long timeout, TimeUnit unit) throws Exception {
        switch (pType) {
            case Local: {
                return LocalStoreWriterProxy.store(locators, multiplex, timeout, unit);
            }
            case TCP: {
                return TCPStoreWriterProxy.store(locators, multiplex, timeout, unit);
            }
            case HTTP: {
                return HTTPStoreWriterProxy.store(locators, multiplex, timeout, unit);
            }
        }
        throw new Exception("Unrecognized proxy type");
    }

    private static IWriterProxy getWriterProxy() throws Exception {
        switch (pType) {
            case Local: {
                return new LocalWriterProxy();
            }
            case TCP: {
                return new TCPWriterProxy();
            }
            case HTTP: {
                return new HTTPWriterProxy();
            }
        }
        throw new Exception("Unrecognized proxy type");
    }

    public static synchronized void initialiseRS() {
        if (TCPConnectionManager.IsInitialized()) {
            return;
        }
        try {
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), new ArrayList(), true));
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Initializing TCP Connection Manager");
        HTTPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig("localhost", new ArrayList(), true));
        HTTPConnectionManager.RegisterEntry((IHTTPConnectionManagerEntry)new HTTPConnectionHandler());
        HTTPConnectionManager.RegisterEntry((IHTTPConnectionManagerEntry)new HTTPStoreConnectionHandler());
        System.out.println(tType.toString());
        long startTime = System.currentTimeMillis();
        switch (tType) {
            case full_reader_test: {
                WriterMultiFieldThread wt = new WriterMultiFieldThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderFullThread rt = new ReaderFullThread(loc, ReaderPremature);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case for_each_reader_test: {
                WriterMultiFieldThread wt = new WriterMultiFieldThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderForeachThread rt = new ReaderForeachThread(loc, ReaderPremature, sendEvents);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case iterator_reader_test: {
                WriterMultiFieldThread wt = new WriterMultiFieldThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderIteratorThread rt = new ReaderIteratorThread(loc, ReaderPremature, -1);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case iterator_two_readers_test: {
                WriterMultiFieldThread wt = new WriterMultiFieldThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderIteratorThread rt1 = new ReaderIteratorThread(loc, ReaderPremature, 1);
                ReaderIteratorThread rt2 = new ReaderIteratorThread(loc, ReaderPremature, 2);
                rt1.start();
                rt2.start();
                wt.join();
                rt1.join();
                rt2.join();
                break;
            }
            case timeout_test: {
                System.out.println("test should end between 10000 milliseconds to 120000 milliseconds");
                long start = System.currentTimeMillis();
                WriterMultiFieldThread wt = new WriterMultiFieldThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, 10000L, TimeUnit.MILLISECONDS, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                wt.join();
                System.out.println("test ended in " + (System.currentTimeMillis() - start) + " milliseconds");
            }
            case url_test: {
                WriterURLThread wt = new WriterURLThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, TestURI);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderURLThread rt = new ReaderURLThread(loc, ReaderPremature);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case file_test: {
                WriterFileThread wt = new WriterFileThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, TestFileName, FileTransportDirective, DoCompress, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderFileThread rt = new ReaderFileThread(loc, ReaderPremature);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case file_mediation_test: {
                WriterFileThread wt = new WriterFileThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, TestFileName, FileTransportDirective, DoCompress, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderFileMediationThread rt = new ReaderFileMediationThread(loc, ReaderPremature, StoreBase, DoStore, 0);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case string_random_test: {
                WriterSimpleThread wt = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderRandomThread rt = new ReaderRandomThread(loc);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case string_random_iterator_test: {
                WriterSimpleThread wt = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderRandomIteratorThread rt = new ReaderRandomIteratorThread(loc);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case store_simple_test: {
                WriterSimpleThread wt1 = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt1.prepare();
                wt1.start();
                URI loc1 = wt1.writer.getLocator();
                WriterSimpleThread wt2 = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt2.prepare();
                wt2.start();
                URI loc2 = wt2.writer.getLocator();
                WriterSimpleThread wt3 = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt3.prepare();
                wt3.start();
                URI loc3 = wt3.writer.getLocator();
                System.out.println(loc1.toString());
                System.out.println(loc2.toString());
                System.out.println(loc3.toString());
                URI storeloc = MainTest.toStore(new URI[]{loc1, loc2, loc3}, Multiplex, 60L, TimeUnit.SECONDS);
                System.out.println(storeloc);
                ReaderForeachThread rt1 = new ReaderForeachThread(storeloc, ReaderPremature, sendEvents);
                ReaderForeachThread rt2 = new ReaderForeachThread(storeloc, ReaderPremature, sendEvents);
                rt1.start();
                rt2.start();
                wt1.join();
                wt2.join();
                wt3.join();
                rt1.join();
                rt2.join();
                break;
            }
            case store_file_test: {
                WriterFileThread wt1 = new WriterFileThread(new LocalWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, TestFileName, FileTransportDirective, DoCompress, Capacity);
                wt1.prepare();
                wt1.start();
                URI loc1 = wt1.writer.getLocator();
                WriterFileThread wt2 = new WriterFileThread(new LocalWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, TestFileName, FileTransportDirective, DoCompress, Capacity);
                wt2.prepare();
                wt2.start();
                URI loc2 = wt2.writer.getLocator();
                WriterFileThread wt3 = new WriterFileThread(new LocalWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, TestFileName, FileTransportDirective, DoCompress, Capacity);
                wt3.prepare();
                wt3.start();
                URI loc3 = wt3.writer.getLocator();
                System.out.println(loc1.toString());
                System.out.println(loc2.toString());
                System.out.println(loc3.toString());
                URI storeloc = MainTest.toStore(new URI[]{loc1, loc2, loc3}, Multiplex, 60L, TimeUnit.SECONDS);
                System.out.println(storeloc);
                ReaderFileMediationThread rt1 = new ReaderFileMediationThread(storeloc, ReaderPremature, StoreBase, DoStore, 0);
                rt1.start();
                ReaderFileMediationThread rt2 = new ReaderFileMediationThread(storeloc, ReaderPremature, StoreBase, DoStore, 1);
                rt2.start();
                rt1.join();
                rt2.join();
                wt1.join();
                wt2.join();
                wt3.join();
                break;
            }
            case object_test: {
                WriterObjectThread wt = new WriterObjectThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderObjectThread rt = new ReaderObjectThread(loc, ReaderPremature);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case event_test: {
                WriterSimpleThread wt = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                ReaderForeachThread rt = new ReaderForeachThread(loc, ReaderPremature, sendEvents);
                rt.start();
                wt.join();
                rt.join();
                break;
            }
            case event_store_test: {
                WriterSimpleThread wt = new WriterSimpleThread(MainTest.getWriterProxy(), WriterItems, WriterPremature, RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit, Capacity, sendEvents);
                wt.prepare();
                wt.start();
                URI loc = wt.writer.getLocator();
                System.out.println(loc.toString());
                URI storeloc = MainTest.toStore(new URI[]{loc}, Multiplex, 60L, TimeUnit.SECONDS);
                System.out.println(storeloc.toString());
                ReaderForeachThread rt1 = new ReaderForeachThread(storeloc, ReaderPremature, sendEvents);
                ReaderForeachThread rt2 = new ReaderForeachThread(storeloc, ReaderPremature, sendEvents);
                rt1.start();
                rt2.start();
                wt.join();
                rt1.join();
                rt2.join();
                break;
            }
        }
        System.out.println("Test took " + (System.currentTimeMillis() - startTime));
        System.out.println("Sleeping for 2000 to allow for any background errors");
        Thread.sleep(2000L);
    }

    public static enum TestType {
        full_reader_test,
        iterator_reader_test,
        for_each_reader_test,
        iterator_two_readers_test,
        timeout_test,
        url_test,
        file_test,
        file_mediation_test,
        string_random_test,
        string_random_iterator_test,
        store_simple_test,
        store_file_test,
        object_test,
        event_test,
        event_store_test;

    }
}

