/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.http;

import gr.uoa.di.madgik.commons.server.http.IHTTPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.proxy.http.HTTPWriterProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreReader;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTTPStoreConnectionHandler
implements IHTTPConnectionManagerEntry {
    private static Logger logger = Logger.getLogger(HTTPStoreConnectionHandler.class.getName());

    public IHTTPConnectionManagerEntry.NamedEntry GetName() {
        return IHTTPConnectionManagerEntry.NamedEntry.gRS2Store;
    }

    public void HandleConnection(Socket socket, String request, BufferedOutputStream out, String key) {
        block5: {
            try {
                IBufferStore store = GRSRegistry.Registry.getStore(key);
                if (store != null) {
                    HTTPWriterProxy newProxy = new HTTPWriterProxy();
                    BufferStoreReader storeReader = new BufferStoreReader(key, newProxy);
                    URI storeAccessLocator = storeReader.populate();
                    logger.log(Level.WARNING, "StoreAccessLocator : " + storeAccessLocator);
                    out.write(storeAccessLocator.toString().getBytes());
                    out.flush();
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "Could not handle incoming mirroring request for key " + key, ex);
            }
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

