/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;

class XPathQueryBuilder
implements QueryBuilder<Condition> {
    private AuthorizableType selectorType = AuthorizableType.AUTHORIZABLE;
    private String groupID;
    private boolean declaredMembersOnly;
    private Condition condition;
    private String sortProperty;
    private QueryBuilder.Direction sortDirection = QueryBuilder.Direction.ASCENDING;
    private boolean sortIgnoreCase;
    private Value bound;
    private long offset;
    private long maxCount = Long.MAX_VALUE;

    XPathQueryBuilder() {
    }

    public void setSelector(Class<? extends Authorizable> selector) {
        this.selectorType = User.class.isAssignableFrom(selector) ? AuthorizableType.USER : (Group.class.isAssignableFrom(selector) ? AuthorizableType.GROUP : AuthorizableType.AUTHORIZABLE);
    }

    public void setScope(String groupID, boolean declaredOnly) {
        this.groupID = groupID;
        this.declaredMembersOnly = declaredOnly;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setSortOrder(String propertyName, QueryBuilder.Direction direction, boolean ignoreCase) {
        this.sortProperty = propertyName;
        this.sortDirection = direction;
        this.sortIgnoreCase = ignoreCase;
    }

    public void setSortOrder(String propertyName, QueryBuilder.Direction direction) {
        this.setSortOrder(propertyName, direction, false);
    }

    public void setLimit(Value bound, long maxCount) {
        this.offset = 0L;
        this.bound = bound;
        this.setMaxCount(maxCount);
    }

    public void setLimit(long offset, long maxCount) {
        this.bound = null;
        this.offset = offset;
        this.setMaxCount(maxCount);
    }

    public Condition nameMatches(String pattern) {
        return new Condition.Node(pattern);
    }

    public Condition neq(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.NE, value);
    }

    public Condition eq(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.EQ, value);
    }

    public Condition lt(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.LT, value);
    }

    public Condition le(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.LE, value);
    }

    public Condition gt(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.GT, value);
    }

    public Condition ge(String relPath, Value value) {
        return new Condition.Property(relPath, RelationOp.GE, value);
    }

    public Condition exists(String relPath) {
        return new Condition.Property(relPath, RelationOp.EX);
    }

    public Condition like(String relPath, String pattern) {
        return new Condition.Property(relPath, RelationOp.LIKE, pattern);
    }

    public Condition contains(String relPath, String searchExpr) {
        return new Condition.Contains(relPath, searchExpr);
    }

    public Condition impersonates(String name) {
        return new Condition.Impersonation(name);
    }

    public Condition not(Condition condition) {
        return new Condition.Not(condition);
    }

    public Condition and(Condition condition1, Condition condition2) {
        return new Condition.And(condition1, condition2);
    }

    public Condition or(Condition condition1, Condition condition2) {
        return new Condition.Or(condition1, condition2);
    }

    Condition property(String relPath, RelationOp op, Value value) {
        return new Condition.Property(relPath, op, value);
    }

    AuthorizableType getSelectorType() {
        return this.selectorType;
    }

    String getGroupID() {
        return this.groupID;
    }

    boolean isDeclaredMembersOnly() {
        return this.declaredMembersOnly;
    }

    Condition getCondition() {
        return this.condition;
    }

    String getSortProperty() {
        return this.sortProperty;
    }

    QueryBuilder.Direction getSortDirection() {
        return this.sortDirection;
    }

    boolean getSortIgnoreCase() {
        return this.sortIgnoreCase;
    }

    Value getBound() {
        return this.bound;
    }

    long getOffset() {
        return this.offset;
    }

    long getMaxCount() {
        return this.maxCount;
    }

    private void setMaxCount(long maxCount) {
        this.maxCount = maxCount == -1L ? Long.MAX_VALUE : maxCount;
    }
}

