/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;

class UserImpl
extends AuthorizableImpl
implements User {
    UserImpl(User dlg, AutoSaveEnabledManager mgr) {
        super((Authorizable)dlg, mgr);
    }

    private User getDelegate() {
        return (User)this.dlg;
    }

    public boolean isAdmin() {
        return this.getDelegate().isAdmin();
    }

    public Credentials getCredentials() throws RepositoryException {
        return this.getDelegate().getCredentials();
    }

    public Impersonation getImpersonation() throws RepositoryException {
        return new ImpersonationImpl(this.getDelegate().getImpersonation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String pw) throws RepositoryException {
        try {
            this.getDelegate().changePassword(pw);
        }
        finally {
            this.mgr.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String pw, String oldPw) throws RepositoryException {
        try {
            this.getDelegate().changePassword(pw, oldPw);
        }
        finally {
            this.mgr.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable(String msg) throws RepositoryException {
        try {
            this.getDelegate().disable(msg);
        }
        finally {
            this.mgr.autosave();
        }
    }

    public boolean isDisabled() throws RepositoryException {
        return this.getDelegate().isDisabled();
    }

    public String getDisabledReason() throws RepositoryException {
        return this.getDelegate().getDisabledReason();
    }

    private final class ImpersonationImpl
    implements Impersonation {
        private final Impersonation dlg;

        private ImpersonationImpl(Impersonation dlg) {
            this.dlg = dlg;
        }

        public PrincipalIterator getImpersonators() throws RepositoryException {
            return this.dlg.getImpersonators();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean grantImpersonation(Principal principal) throws RepositoryException {
            try {
                boolean bl = this.dlg.grantImpersonation(principal);
                return bl;
            }
            finally {
                UserImpl.this.mgr.autosave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean revokeImpersonation(Principal principal) throws RepositoryException {
            try {
                boolean bl = this.dlg.revokeImpersonation(principal);
                return bl;
            }
            finally {
                UserImpl.this.mgr.autosave();
            }
        }

        public boolean allows(Subject subject) throws RepositoryException {
            return this.dlg.allows(subject);
        }
    }
}

