/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class UserValidatorProvider
extends ValidatorProvider {
    private final ConfigurationParameters config;
    private MembershipProvider membershipProvider;

    UserValidatorProvider(ConfigurationParameters config) {
        this.config = (ConfigurationParameters)Preconditions.checkNotNull((Object)config);
    }

    @Override
    @Nonnull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        this.membershipProvider = new MembershipProvider(new ImmutableRoot(after), this.config);
        return new UserValidator(new ImmutableTree(before), new ImmutableTree(after), this);
    }

    @Nonnull
    ConfigurationParameters getConfig() {
        return this.config;
    }

    @Nonnull
    MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }
}

