/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.AuthorizableIterator;
import org.apache.jackrabbit.oak.security.user.AuthorizableProperties;
import org.apache.jackrabbit.oak.security.user.AuthorizablePropertiesImpl;
import org.apache.jackrabbit.oak.security.user.GroupImpl;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthorizableImpl
implements Authorizable,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(AuthorizableImpl.class);
    private final String id;
    private final Tree tree;
    private final UserManagerImpl userManager;
    private String principalName;
    private AuthorizableProperties properties;
    private int hashCode;

    AuthorizableImpl(@Nonnull String id, @Nonnull Tree tree, @Nonnull UserManagerImpl userManager) throws RepositoryException {
        this.checkValidTree(tree);
        this.id = id;
        this.tree = tree;
        this.userManager = userManager;
    }

    abstract void checkValidTree(Tree var1) throws RepositoryException;

    static boolean isValidAuthorizableImpl(Authorizable authorizable) {
        return authorizable instanceof AuthorizableImpl;
    }

    public String getID() {
        return this.id;
    }

    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.getMembership(false);
    }

    public Iterator<Group> memberOf() throws RepositoryException {
        return this.getMembership(true);
    }

    public void remove() throws RepositoryException {
        if (!this.isGroup() && ((User)this).isAdmin()) {
            throw new RepositoryException("The administrator cannot be removed.");
        }
        this.userManager.onRemove(this);
        this.getTree().remove();
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.getPropertyNames(".");
    }

    public Iterator<String> getPropertyNames(String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().getNames(relPath);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().hasProperty(relPath);
    }

    public Value[] getProperty(String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().getProperty(relPath);
    }

    public void setProperty(String relPath, Value value) throws RepositoryException {
        this.getAuthorizableProperties().setProperty(relPath, value);
    }

    public void setProperty(String relPath, Value[] values) throws RepositoryException {
        this.getAuthorizableProperties().setProperty(relPath, values);
    }

    public boolean removeProperty(String relPath) throws RepositoryException {
        return this.getAuthorizableProperties().removeProperty(relPath);
    }

    public String getPath() throws RepositoryException {
        return this.userManager.getNamePathMapper().getJcrPath(this.getTree().getPath());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isGroup() ? "group:" : "user:");
            sb.append(':');
            sb.append(this.id);
            sb.append('_');
            sb.append(this.userManager.hashCode());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthorizableImpl) {
            AuthorizableImpl otherAuth = (AuthorizableImpl)obj;
            return this.isGroup() == otherAuth.isGroup() && this.id.equals(otherAuth.id) && this.userManager.equals(otherAuth.userManager);
        }
        return false;
    }

    public String toString() {
        String typeStr = this.isGroup() ? "Group '" : "User '";
        return typeStr + this.id + '\'';
    }

    @Nonnull
    Tree getTree() {
        if (this.tree.exists()) {
            return this.tree;
        }
        throw new IllegalStateException("Authorizable " + this.id + ": underlying tree has been disconnected.");
    }

    @Nonnull
    String getPrincipalName() throws RepositoryException {
        if (this.principalName == null) {
            PropertyState pNameProp = this.tree.getProperty("rep:principalName");
            if (pNameProp != null) {
                this.principalName = pNameProp.getValue(Type.STRING);
            } else {
                String msg = "Authorizable without principal name " + this.id;
                log.warn(msg);
                throw new RepositoryException(msg);
            }
        }
        return this.principalName;
    }

    @Nonnull
    UserManagerImpl getUserManager() {
        return this.userManager;
    }

    @Nonnull
    MembershipProvider getMembershipProvider() {
        return this.userManager.getMembershipProvider();
    }

    boolean isEveryone() throws RepositoryException {
        return this.isGroup() && "everyone".equals(this.getPrincipalName());
    }

    private AuthorizableProperties getAuthorizableProperties() {
        if (this.properties == null) {
            this.properties = new AuthorizablePropertiesImpl(this, this.userManager.getNamePathMapper());
        }
        return this.properties;
    }

    @Nonnull
    private Iterator<Group> getMembership(boolean includeInherited) throws RepositoryException {
        if (this.isEveryone()) {
            return Collections.emptySet().iterator();
        }
        MembershipProvider mMgr = this.getMembershipProvider();
        Iterator oakPaths = mMgr.getMembership(this.getTree(), includeInherited);
        Authorizable everyoneGroup = this.userManager.getAuthorizable((Principal)((Object)EveryonePrincipal.getInstance()));
        if (everyoneGroup instanceof GroupImpl) {
            String everyonePath = ((GroupImpl)everyoneGroup).getTree().getPath();
            oakPaths = Iterators.concat(oakPaths, (Iterator)ImmutableSet.of((Object)everyonePath).iterator());
        }
        if (oakPaths.hasNext()) {
            AuthorizableIterator groups = AuthorizableIterator.create(oakPaths, this.userManager, AuthorizableType.GROUP);
            return new RangeIteratorAdapter((Iterator)groups, groups.getSize());
        }
        return RangeIteratorAdapter.EMPTY;
    }
}

