/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public class InImpl
extends ConstraintImpl {
    private final DynamicOperandImpl operand1;
    private final List<StaticOperandImpl> operand2List;

    public InImpl(DynamicOperandImpl operand1, List<StaticOperandImpl> operand2List) {
        this.operand1 = operand1;
        this.operand2List = operand2List;
    }

    public DynamicOperandImpl getOperand1() {
        return this.operand1;
    }

    public List<StaticOperandImpl> getOperand2List() {
        return this.operand2List;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        PropertyExistenceImpl p = this.operand1.getPropertyExistence();
        if (p == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(p);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.operand1.getSelectors();
    }

    @Override
    public Map<DynamicOperandImpl, Set<StaticOperandImpl>> getInMap() {
        HashSet set = Sets.newHashSet(this.operand2List);
        return Collections.singletonMap(this.operand1, set);
    }

    @Override
    public boolean evaluate() {
        PropertyValue p1 = this.operand1.currentProperty();
        if (p1 == null) {
            return false;
        }
        for (StaticOperandImpl operand2 : this.operand2List) {
            PropertyValue p2 = operand2.currentValue();
            if (p2 == null || !PropertyValues.match(p1, p2 = this.convertValueToType(p2, p1))) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.operand1).append(" in(");
        int i = 0;
        for (StaticOperandImpl operand2 : this.operand2List) {
            if (i++ > 0) {
                buff.append(", ");
            }
            buff.append(operand2);
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public void restrict(FilterImpl f) {
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>();
        for (StaticOperandImpl s : this.operand2List) {
            if (!PropertyValues.canConvert(s.getPropertyType(), this.operand1.getPropertyType())) {
                throw new IllegalArgumentException("Unsupported conversion from property type " + PropertyType.nameFromValue((int)s.getPropertyType()) + " to property type " + PropertyType.nameFromValue((int)this.operand1.getPropertyType()));
            }
            list.add(s.currentValue());
        }
        if (list != null) {
            this.operand1.restrictList(f, list);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        for (StaticOperandImpl op : this.operand2List) {
            if (op.currentValue() != null) continue;
            return;
        }
        if (this.operand1.canRestrictSelector(s)) {
            s.restrictSelector(this);
        }
    }
}

