/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.kernel.KernelNodeStore;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.cache.CachingDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
public class DocumentNodeStoreService {
    private static final String DEFAULT_URI = "mongodb://localhost:27017/oak";
    private static final int DEFAULT_CACHE = 256;
    private static final int DEFAULT_OFF_HEAP_CACHE = 0;
    private static final int DEFAULT_CHANGES_SIZE = 256;
    private static final String DEFAULT_DB = "oak";
    private static final String PREFIX = "oak.documentstore.";
    private static final String FWK_PROP_URI = "oak.mongo.uri";
    private static final String FWK_PROP_DB = "oak.mongo.db";
    @Property(boolValue={false}, propertyPrivate=true)
    private static final String PROP_USE_MK = "useMK";
    @Property(value={"mongodb://localhost:27017/oak"})
    private static final String PROP_URI = "mongouri";
    @Property(value={"oak"})
    private static final String PROP_DB = "db";
    @Property(intValue={256})
    private static final String PROP_CACHE = "cache";
    @Property(intValue={0})
    private static final String PROP_OFF_HEAP_CACHE = "offHeapCache";
    @Property(intValue={256})
    private static final String PROP_CHANGES_SIZE = "changesSize";
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private static final long MB = 0x100000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;
    private final List<Registration> registrations = new ArrayList<Registration>();
    private WhiteboardExecutor executor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile BlobStore blobStore;
    private DocumentMK mk;
    private ObserverTracker observerTracker;
    private ComponentContext context;
    private Whiteboard whiteboard;
    private static final long DEFAULT_VER_GC_MAX_AGE = TimeUnit.DAYS.toSeconds(1L);
    public static final String PROP_VER_GC_MAX_AGE = "versionGcMaxAgeInSecs";
    private long versionGcMaxAgeInSecs = DEFAULT_VER_GC_MAX_AGE;
    public static final String PROP_REV_RECOVERY_INTERVAL = "lastRevRecoveryJobIntervalInSecs";
    private static final long DEFAULT_BLOB_GC_MAX_AGE = TimeUnit.HOURS.toMillis(24L);
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";
    private long blobGcMaxAgeInSecs = DEFAULT_BLOB_GC_MAX_AGE;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) throws Exception {
        this.context = context;
        this.whiteboard = new OsgiWhiteboard(context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        if (this.blobStore == null && PropertiesUtil.toBoolean((Object)this.prop(CUSTOM_BLOB_STORE), (boolean)false)) {
            this.log.info("BlobStore use enabled. DocumentNodeStoreService would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
        this.modified(config);
    }

    protected void registerNodeStore() throws IOException {
        Observable store;
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return;
        }
        String uri = PropertiesUtil.toString((Object)this.prop(PROP_URI, FWK_PROP_URI), (String)DEFAULT_URI);
        String db = PropertiesUtil.toString((Object)this.prop(PROP_DB, FWK_PROP_DB), (String)DEFAULT_DB);
        int offHeapCache = PropertiesUtil.toInteger((Object)this.prop(PROP_OFF_HEAP_CACHE), (int)0);
        int cacheSize = PropertiesUtil.toInteger((Object)this.prop(PROP_CACHE), (int)256);
        int changesSize = PropertiesUtil.toInteger((Object)this.prop(PROP_CHANGES_SIZE), (int)256);
        boolean useMK = PropertiesUtil.toBoolean(this.context.getProperties().get(PROP_USE_MK), (boolean)false);
        MongoClientOptions.Builder builder = MongoConnection.getDefaultBuilder();
        MongoClientURI mongoURI = new MongoClientURI(uri, builder);
        if (this.log.isInfoEnabled()) {
            String type = useMK ? "MK" : "NodeStore";
            this.log.info("Starting Document{} with host={}, db={}, cache size (MB)={}, Off Heap Cache size (MB)={}, 'changes' collection size (MB)={}", new Object[]{type, mongoURI.getHosts(), db, cacheSize, offHeapCache, changesSize});
            this.log.info("Mongo Connection details {}", (Object)MongoConnection.toString(mongoURI.getOptions()));
        }
        MongoClient client = new MongoClient(mongoURI);
        DB mongoDB = client.getDB(db);
        DocumentMK.Builder mkBuilder = new DocumentMK.Builder().memoryCacheSize((long)cacheSize * 0x100000L).offHeapCacheSize((long)offHeapCache * 0x100000L);
        if (this.blobStore != null) {
            mkBuilder.setBlobStore(this.blobStore);
        }
        mkBuilder.setMongoDB(mongoDB, changesSize);
        mkBuilder.setExecutor(this.executor);
        this.mk = mkBuilder.open();
        this.log.info("Connected to database {}", (Object)mongoDB);
        this.registerJMXBeans(this.mk.getNodeStore());
        this.registerLastRevRecoveryJob(this.mk.getNodeStore());
        if (useMK) {
            KernelNodeStore kns = new KernelNodeStore(this.mk);
            store = kns;
            this.observerTracker = new ObserverTracker(kns);
        } else {
            DocumentNodeStore mns;
            store = mns = this.mk.getNodeStore();
            this.observerTracker = new ObserverTracker(mns);
        }
        this.observerTracker.start(this.context.getBundleContext());
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", DocumentNodeStore.class.getName());
        this.reg = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)store, props);
    }

    @Modified
    protected void modified(Map<String, ?> config) {
        this.versionGcMaxAgeInSecs = PropertiesUtil.toLong(config.get(PROP_VER_GC_MAX_AGE), (long)DEFAULT_VER_GC_MAX_AGE);
        this.blobGcMaxAgeInSecs = PropertiesUtil.toLong(config.get(PROP_BLOB_GC_MAX_AGE), (long)DEFAULT_BLOB_GC_MAX_AGE);
    }

    @Deactivate
    protected void deactivate() {
        if (this.observerTracker != null) {
            this.observerTracker.stop();
        }
        this.unregisterNodeStore();
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.log.info("Initializing DocumentNodeStore with BlobStore [{}]", (Object)blobStore);
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    private void unregisterNodeStore() {
        for (Registration r : this.registrations) {
            r.unregister();
        }
        if (this.reg != null) {
            this.reg.unregister();
        }
        if (this.mk != null) {
            this.mk.dispose();
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private void registerJMXBeans(final DocumentNodeStore store) throws IOException {
        DocumentStore ds;
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeCacheStats(), "CacheStats", store.getNodeCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getNodeChildrenCacheStats(), "CacheStats", store.getNodeChildrenCacheStats().getName()));
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, store.getDocChildrenCacheStats(), "CacheStats", store.getDocChildrenCacheStats().getName()));
        DiffCache cl = store.getDiffCache();
        if (cl instanceof MemoryDiffCache) {
            MemoryDiffCache mcl = (MemoryDiffCache)cl;
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, mcl.getDiffCacheStats(), "CacheStats", mcl.getDiffCacheStats().getName()));
        }
        if ((ds = store.getDocumentStore()) instanceof CachingDocumentStore) {
            CachingDocumentStore cds = (CachingDocumentStore)ds;
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, cds.getCacheStats(), "CacheStats", cds.getCacheStats().getName()));
        }
        if (store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            BlobGarbageCollector gc = new BlobGarbageCollector(){

                @Override
                public void collectGarbage() throws Exception {
                    store.createBlobGarbageCollector(DocumentNodeStoreService.this.blobGcMaxAgeInSecs).collectGarbage();
                }
            };
            this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, BlobGCMBean.class, new BlobGC(gc, this.executor), "BlobGarbageCollection", "Document node store blob garbage collection"));
        }
        RevisionGC revisionGC = new RevisionGC(new Runnable(){

            @Override
            public void run() {
                store.getVersionGarbageCollector().gc(DocumentNodeStoreService.this.versionGcMaxAgeInSecs, TimeUnit.SECONDS);
            }
        }, this.executor);
        this.registrations.add(WhiteboardUtils.registerMBean(this.whiteboard, RevisionGCMBean.class, revisionGC, "RevisionGarbageCollection", "Document node store revision garbage collection"));
    }

    private void registerLastRevRecoveryJob(final DocumentNodeStore nodeStore) {
        long leaseTime = PropertiesUtil.toLong(this.context.getProperties().get(PROP_REV_RECOVERY_INTERVAL), (long)60000L);
        Runnable recoverJob = new Runnable(){

            @Override
            public void run() {
                nodeStore.getLastRevRecoveryAgent().performRecoveryIfNeeded();
            }
        };
        this.registrations.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, recoverJob, TimeUnit.MILLISECONDS.toSeconds(leaseTime)));
    }

    private Object prop(String propName) {
        return this.prop(propName, PREFIX + propName);
    }

    private Object prop(String propName, String fwkPropName) {
        String value = this.context.getBundleContext().getProperty(fwkPropName);
        if (value != null) {
            return value;
        }
        return this.context.getProperties().get(propName);
    }
}

