/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AsyncUploadCallback;
import org.apache.jackrabbit.core.data.AsyncUploadResult;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;

public class DataStoreWrapperBackend
implements Backend {
    private DataStore dataStore;

    public DataStoreWrapperBackend(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void init(CachingDataStore store, String homeDir, String config) throws DataStoreException {
    }

    public InputStream read(DataIdentifier identifier) throws DataStoreException {
        return this.dataStore.getRecordIfStored(identifier).getStream();
    }

    public long getLength(DataIdentifier identifier) throws DataStoreException {
        return this.dataStore.getRecord(identifier).getLength();
    }

    public long getLastModified(DataIdentifier identifier) throws DataStoreException {
        return this.dataStore.getRecord(identifier).getLastModified();
    }

    public void writeAsync(DataIdentifier dataIdentifier, File file, AsyncUploadCallback asyncUploadCallback) throws DataStoreException {
        asyncUploadCallback.onFailure(new AsyncUploadResult(dataIdentifier, file));
    }

    public void write(DataIdentifier identifier, File file) throws DataStoreException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            this.dataStore.addRecord((InputStream)stream);
        }
        catch (IOException io) {
            try {
                throw new DataStoreException("Error retrieving stream from : " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return this.dataStore.getAllIdentifiers();
    }

    public boolean exists(DataIdentifier identifier, boolean touch) throws DataStoreException {
        return this.exists(identifier);
    }

    public boolean exists(DataIdentifier identifier) throws DataStoreException {
        return this.dataStore.getRecordIfStored(identifier) != null;
    }

    public void close() throws DataStoreException {
        this.dataStore.close();
    }

    public Set<DataIdentifier> deleteAllOlderThan(long timestamp) throws DataStoreException {
        this.dataStore.deleteAllOlderThan(timestamp);
        return Sets.newHashSet();
    }

    public void deleteRecord(DataIdentifier identifier) throws DataStoreException {
        if (this.dataStore instanceof MultiDataStoreAware) {
            ((MultiDataStoreAware)this.dataStore).deleteRecord(identifier);
        }
    }
}

