/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.kernel.BlobSerializer;
import org.apache.jackrabbit.oak.kernel.JsonSerializer;
import org.apache.jackrabbit.oak.kernel.JsopDiff;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class NodeStoreKernel
implements MicroKernel {
    private static final CommitHook CONFLICT_HOOK = new EditorHook(new ValidatorProvider(){

        @Override
        protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
            return new DefaultValidator(){

                @Override
                public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
                    if (name.equals(":conflict")) {
                        throw new CommitFailedException("State", 0, "Conflict");
                    }
                    return null;
                }

                @Override
                public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
                    return this;
                }
            };
        }
    });
    private final NodeStore store;
    private final Map<String, Revision> revisions = Maps.newLinkedHashMap();
    private final Map<String, Blob> blobs = Maps.newConcurrentMap();
    private final BlobSerializer blobSerializer = new BlobSerializer(){

        @Override
        public String serialize(Blob blob) {
            String id = AbstractBlob.calculateSha256(blob).toString();
            NodeStoreKernel.this.blobs.put(id, blob);
            return id;
        }
    };
    private Revision head;

    public NodeStoreKernel(NodeStore store) {
        this.store = store;
        this.head = new Revision(store.getRoot());
        this.revisions.put(this.head.id, this.head);
    }

    @Nonnull
    private synchronized Revision getRevision(@CheckForNull String id) {
        if (id == null) {
            return this.head;
        }
        Revision revision = this.revisions.get(id);
        if (revision != null) {
            return revision;
        }
        throw new MicroKernelException("Revision not found: " + id);
    }

    private NodeState getRoot(String id) throws MicroKernelException {
        return this.getRevision(id).root;
    }

    private NodeState getNode(String revision, String path) throws MicroKernelException {
        NodeState node = this.getRoot(revision);
        if (path != null) {
            for (String element : PathUtils.elements((String)path)) {
                node = node.getChildNode(element);
            }
        }
        return node;
    }

    private void applyJsop(NodeBuilder builder, String path, String jsonDiff) throws MicroKernelException {
        for (String element : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(element);
        }
        if (!builder.exists()) {
            throw new MicroKernelException("Path not found: " + path);
        }
        this.applyJsop(builder, jsonDiff);
    }

    private void applyJsop(NodeBuilder builder, String jsonDiff) {
        JsopTokenizer tokenizer = new JsopTokenizer(jsonDiff);
        int token = tokenizer.read();
        while (token != 0) {
            String path = tokenizer.readString();
            String name = PathUtils.getName((String)path);
            block1 : switch (token) {
                case 43: {
                    tokenizer.read(58);
                    tokenizer.read(123);
                    NodeBuilder parent = this.getNode(builder, PathUtils.getParentPath((String)path));
                    if (builder.hasChildNode(name)) {
                        throw new MicroKernelException("Node already exists: " + path);
                    }
                    this.addNode(parent.setChildNode(name), tokenizer);
                    break;
                }
                case 45: {
                    this.getNode(builder, path).remove();
                    break;
                }
                case 94: {
                    tokenizer.read(58);
                    NodeBuilder node = this.getNode(builder, PathUtils.getParentPath((String)path));
                    switch (tokenizer.read()) {
                        case 5: {
                            node.removeProperty(name);
                            break block1;
                        }
                        case 4: {
                            node.setProperty(name, Boolean.FALSE);
                            break block1;
                        }
                        case 3: {
                            node.setProperty(name, Boolean.TRUE);
                            break block1;
                        }
                        case 1: {
                            node.setProperty(name, tokenizer.getToken());
                            break block1;
                        }
                        case 2: {
                            String value = tokenizer.getToken();
                            try {
                                node.setProperty(name, Long.parseLong(value));
                            }
                            catch (NumberFormatException e) {
                                node.setProperty(name, Double.parseDouble(value));
                            }
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case 62: {
                    tokenizer.read(58);
                    String targetPath = tokenizer.readString();
                    NodeBuilder targetParent = this.getNode(builder, PathUtils.getParentPath((String)targetPath));
                    String targetName = PathUtils.getName((String)targetPath);
                    if (path.equals(targetPath) || PathUtils.isAncestor((String)path, (String)targetPath)) {
                        throw new MicroKernelException("Target path must not be the same or a descendant of the source path: " + targetPath);
                    }
                    if (targetParent.hasChildNode(targetName)) {
                        throw new MicroKernelException("Target node exists: " + targetPath);
                    }
                    if (this.getNode(builder, path).moveTo(targetParent, targetName)) break;
                    throw new MicroKernelException("Move failed");
                }
                case 42: {
                    tokenizer.read(58);
                    String copyTarget = tokenizer.readString();
                    String copyTargetPath = PathUtils.getParentPath((String)copyTarget);
                    String copyTargetName = PathUtils.getName((String)copyTarget);
                    NodeState copySource = this.getNode(builder, path).getNodeState();
                    NodeBuilder copyTargetParent = this.getNode(builder, copyTargetPath);
                    if (copySource.exists() && !copyTargetParent.hasChildNode(copyTargetName)) {
                        copyTargetParent.setChildNode(copyTargetName, copySource);
                        break;
                    }
                    throw new MicroKernelException("Copy failed");
                }
                default: {
                    throw new MicroKernelException("Unexpected token " + (char)token + " in " + jsonDiff);
                }
            }
            token = tokenizer.read();
        }
    }

    private NodeBuilder getNode(NodeBuilder builder, String path) {
        for (String element : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(element);
        }
        if (builder.exists()) {
            return builder;
        }
        throw new MicroKernelException("Path not found: " + path);
    }

    private void addNode(NodeBuilder builder, JsopTokenizer tokenizer) throws MicroKernelException {
        if (tokenizer.matches(125)) {
            return;
        }
        block10: do {
            String name = tokenizer.readString();
            tokenizer.read(58);
            switch (tokenizer.read()) {
                case 123: {
                    NodeBuilder child = builder.setChildNode(name);
                    this.addNode(child, tokenizer);
                    break;
                }
                case 91: {
                    ArrayList array = Lists.newArrayList();
                    while (tokenizer.matches(2)) {
                        array.add(Long.parseLong(tokenizer.getToken()));
                        tokenizer.matches(44);
                    }
                    tokenizer.read(93);
                    builder.setProperty(name, array, Type.LONGS);
                    break;
                }
                case 4: {
                    builder.setProperty(name, Boolean.FALSE);
                    break;
                }
                case 3: {
                    builder.setProperty(name, Boolean.TRUE);
                    break;
                }
                case 2: {
                    String value = tokenizer.getToken();
                    try {
                        builder.setProperty(name, Long.parseLong(value));
                    }
                    catch (NumberFormatException e) {
                        builder.setProperty(name, Double.parseDouble(value));
                    }
                    continue block10;
                }
                case 1: {
                    builder.setProperty(name, tokenizer.getToken());
                    break;
                }
                default: {
                    throw new MicroKernelException("Unexpected token: " + tokenizer.getEscapedToken());
                }
            }
        } while (tokenizer.matches(44));
        tokenizer.read(125);
    }

    public synchronized String getHeadRevision() {
        NodeState root = this.store.getRoot();
        if (!root.equals(this.head.root)) {
            this.head = new Revision(this.head, root, "external");
            this.revisions.put(this.head.id, this.head);
            this.notifyAll();
        }
        return this.head.id;
    }

    public String checkpoint(long lifetime) {
        return this.getHeadRevision();
    }

    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        if (maxEntries < 0) {
            maxEntries = Integer.MAX_VALUE;
        }
        LinkedList list = Lists.newLinkedList();
        Revision revision = this.getRevision(null);
        while (revision != null && revision.base != null && revision.timestamp >= since) {
            list.addFirst(revision);
            revision = revision.base;
        }
        JsopBuilder json = new JsopBuilder();
        json.array();
        int count = 0;
        for (Revision rev : list) {
            if (rev.hasPathChanged(path)) continue;
            if (count++ > maxEntries) break;
            json.object();
            json.key("id").value(rev.id);
            json.key("ts").value(rev.timestamp);
            json.key("msg").value(rev.message);
            json.endObject();
        }
        json.endArray();
        return json.toString();
    }

    public synchronized String waitForCommit(String oldHeadRevisionId, long timeout) throws MicroKernelException, InterruptedException {
        long stop = System.currentTimeMillis() + timeout;
        while (this.head.id.equals(oldHeadRevisionId) && timeout > 0L) {
            this.wait(timeout);
            timeout = stop - System.currentTimeMillis();
        }
        return this.head.id;
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        LinkedList list = Lists.newLinkedList();
        Revision revision = this.getRevision(toRevisionId);
        while (revision != null) {
            list.addFirst(revision);
            if (revision.id.equals(fromRevisionId)) break;
            if (revision.base == null) {
                if (this.getRevision(fromRevisionId).branch != null) {
                    throw new MicroKernelException();
                }
                list.clear();
                break;
            }
            revision = revision.base;
        }
        JsopBuilder json = new JsopBuilder();
        json.array();
        for (Revision rev : list) {
            String jsop = rev.getPathChanges(path, this.blobSerializer);
            if (jsop.isEmpty()) continue;
            json.object();
            json.key("id").value(rev.id);
            json.key("ts").value(rev.timestamp);
            json.key("msg").value(rev.message);
            json.key("changes").value(jsop);
            json.endObject();
        }
        json.endArray();
        return json.toString();
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws MicroKernelException {
        NodeState before = this.getNode(fromRevisionId, path);
        NodeState after = this.getNode(toRevisionId, path);
        JsopDiff diff = new JsopDiff(path, depth);
        after.compareAgainstBaseState(before, diff);
        return diff.toString();
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        return this.getNode(revisionId, path).exists();
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        NodeState node = this.getNode(revisionId, path);
        if (node.exists()) {
            return node.getChildNodeCount(Long.MAX_VALUE);
        }
        throw new MicroKernelException("Node not found: " + revisionId + path);
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        NodeState node = this.getNode(revisionId, path);
        if (node.exists()) {
            if (maxChildNodes < 0) {
                maxChildNodes = Integer.MAX_VALUE;
            }
            if (filter == null) {
                filter = "{}";
            }
            JsonSerializer json = new JsonSerializer(depth, offset, maxChildNodes, filter, this.blobSerializer);
            json.serialize(node);
            return json.toString();
        }
        return null;
    }

    public synchronized String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        Revision revision = this.getRevision(revisionId);
        NodeBuilder builder = revision.branch;
        if (builder == null) {
            builder = revision.root.builder();
        }
        this.applyJsop(builder, path, jsonDiff);
        if (revision.branch != null) {
            revision = new Revision(revision, builder.getNodeState(), message);
        } else {
            try {
                CommitInfo info = new CommitInfo("oak:unknown", null);
                NodeState newRoot = this.store.merge(builder, CONFLICT_HOOK, info);
                if (newRoot.equals(this.head.root)) {
                    return this.head.id;
                }
                this.head = revision = new Revision(this.head, newRoot, message);
                this.notifyAll();
            }
            catch (CommitFailedException e) {
                throw new MicroKernelException((Throwable)e);
            }
        }
        this.revisions.put(revision.id, revision);
        return revision.id;
    }

    public synchronized String branch(String trunkRevisionId) throws MicroKernelException {
        Revision branch = new Revision(this.getRevision(trunkRevisionId));
        this.revisions.put(branch.id, branch);
        return branch.id;
    }

    public synchronized String merge(String branchRevisionId, String message) throws MicroKernelException {
        Revision revision = this.getRevision(branchRevisionId);
        if (revision.branch == null) {
            throw new MicroKernelException("Branch not found: " + branchRevisionId);
        }
        try {
            CommitInfo info = new CommitInfo("oak:unknown", null);
            NodeState newRoot = this.store.merge(revision.branch, CONFLICT_HOOK, info);
            if (!newRoot.equals(this.head.root)) {
                this.head = new Revision(this.head, newRoot, message);
                this.revisions.put(this.head.id, this.head);
                this.notifyAll();
            }
        }
        catch (CommitFailedException e) {
            throw new MicroKernelException((Throwable)e);
        }
        return this.head.id;
    }

    public String rebase(String branchRevisionId, String newBaseRevisionId) throws MicroKernelException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public synchronized String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws MicroKernelException {
        Revision revision = this.getRevision(branchRevisionId);
        if (revision.branch == null) {
            throw new MicroKernelException("Branch not found: " + branchRevisionId);
        }
        Revision ancestor = this.getRevision(ancestorRevisionId);
        while (!ancestor.id.equals(revision.id)) {
            if ((revision = revision.base).branch != null) continue;
            throw new MicroKernelException(ancestorRevisionId + " is not " + "an ancestor revision of " + branchRevisionId);
        }
        Revision r = new Revision(ancestor);
        this.revisions.put(r.id, r);
        return r.id;
    }

    public long getLength(String blobId) throws MicroKernelException {
        Blob blob = this.blobs.get(blobId);
        if (blob != null) {
            return blob.length();
        }
        throw new MicroKernelException("Blob not found: " + blobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        Blob blob = this.blobs.get(blobId);
        if (blob != null) {
            int n;
            InputStream stream = blob.getNewStream();
            try {
                ByteStreams.skipFully((InputStream)stream, (long)pos);
                n = stream.read(buff, off, length);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MicroKernelException("Failed to read a blob", (Throwable)e);
                }
            }
            stream.close();
            return n;
        }
        throw new MicroKernelException("Blob not found: " + blobId);
    }

    public String write(InputStream in) throws MicroKernelException {
        try {
            final Hasher hasher = Hashing.sha256().newHasher();
            Blob blob = this.store.createBlob(new CheckedInputStream(in, new Checksum(){

                @Override
                public void update(byte[] b, int off, int len) {
                    hasher.putBytes(b, off, len);
                }

                @Override
                public void update(int b) {
                    hasher.putByte((byte)b);
                }

                @Override
                public void reset() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long getValue() {
                    throw new UnsupportedOperationException();
                }
            }));
            HashCode hash = hasher.hash();
            if (!(blob instanceof AbstractBlob)) {
                final Blob b = blob;
                blob = new AbstractBlob(hash){

                    @Override
                    public long length() {
                        return b.length();
                    }

                    @Override
                    public InputStream getNewStream() {
                        return b.getNewStream();
                    }
                };
            }
            String id = hash.toString();
            this.blobs.put(id, blob);
            return id;
        }
        catch (IOException e) {
            throw new MicroKernelException("Failed to create a blob", (Throwable)e);
        }
    }

    private static NodeState getNode(NodeState node, String path) {
        if (path != null) {
            for (String element : PathUtils.elements((String)path)) {
                node = node.getChildNode(element);
            }
        }
        return node;
    }

    private static class Revision {
        private final Revision base;
        private final NodeBuilder branch;
        private final String id = UUID.randomUUID().toString();
        private final NodeState root;
        private final String message;
        private final long timestamp;

        Revision(NodeState root) {
            this.base = null;
            this.branch = null;
            this.root = root;
            this.message = "start";
            this.timestamp = 0L;
        }

        Revision(Revision base) {
            this.base = base;
            this.branch = base.root.builder();
            this.root = base.root;
            this.message = "branch";
            this.timestamp = System.currentTimeMillis();
        }

        public Revision(Revision base, NodeState root, String message) {
            this.base = base;
            this.branch = base.branch;
            this.root = root;
            this.message = message;
            this.timestamp = System.currentTimeMillis();
        }

        boolean hasPathChanged(String path) {
            return this.base != null && NodeStoreKernel.getNode(this.root, path).equals(NodeStoreKernel.getNode(this.base.root, path));
        }

        String getPathChanges(String path, BlobSerializer blobs) {
            JsopDiff diff = new JsopDiff(blobs, path);
            if (this.base != null) {
                NodeStoreKernel.getNode(this.root, path).compareAgainstBaseState(NodeStoreKernel.getNode(this.base.root, path), diff);
            }
            return diff.toString();
        }
    }
}

