/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

final class DataFileDefrag {
    RandomAccessInterface randomAccessOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex pointerLookup;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database db, DataFileCache cache, String dataFileName) {
        this.database = db;
        this.cache = cache;
        this.scale = cache.cacheFileScale;
        this.dataFileName = dataFileName;
    }

    /*
     * Loose catch block
     */
    void process() {
        block20: {
            boolean complete = false;
            this.database.logger.logDetailEvent("Defrag process begins");
            this.transactionRowLookup = this.database.txManager.getTransactionIDList();
            this.database.logger.logDetailEvent("transaction count " + this.transactionRowLookup.size());
            HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
            this.rootsList = new int[allTables.size()][];
            int maxSize = 0;
            int tSize = allTables.size();
            for (int i = 0; i < tSize; ++i) {
                PersistentStore store;
                int size;
                Table table = (Table)allTables.get(i);
                if (table.getTableType() != 5 || (size = (store = this.database.persistentStoreCollection.getStore(table)).elementCount()) <= maxSize) continue;
                maxSize = size;
            }
            this.pointerLookup = new DoubleIntIndex(maxSize, false);
            int type = this.database.logger.isStoredFileAccess() ? 3 : 0;
            this.randomAccessOut = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".new", false, type);
            this.randomAccessOut.write(new byte[this.cache.initialFreePos], 0, this.cache.initialFreePos);
            this.fileOffset = this.cache.initialFreePos;
            int tSize2 = allTables.size();
            for (int i = 0; i < tSize2; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 5) {
                    int[] rootsArray = this.writeTableToDataFile(t);
                    this.rootsList[i] = rootsArray;
                    this.randomAccessOut.synch();
                } else {
                    this.rootsList[i] = null;
                }
                this.database.logger.logDetailEvent("table complete " + t.getName().name);
            }
            this.randomAccessOut.seek(12L);
            this.randomAccessOut.writeLong(this.fileOffset);
            int flags = 0;
            if (this.database.logger.propIncrementBackup) {
                flags = BitMap.set(flags, 1);
            }
            flags = BitMap.set(flags, 4);
            flags = BitMap.set(flags, 2);
            this.randomAccessOut.seek(28L);
            this.randomAccessOut.writeInt(flags);
            this.randomAccessOut.synch();
            this.randomAccessOut.close();
            this.randomAccessOut = null;
            for (int[] roots : this.rootsList) {
                if (roots == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList(roots, ",", ""));
            }
            complete = true;
            Object var10_16 = null;
            try {
                if (this.randomAccessOut != null) {
                    this.randomAccessOut.close();
                }
            }
            catch (Throwable t) {
                complete = false;
            }
            if (!complete) {
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
            break block20;
            {
                catch (IOException e) {
                    throw Error.error(452, e);
                }
                catch (OutOfMemoryError e) {
                    this.database.logger.logSevereEvent("defrag failed - out of memory - required: " + maxSize * 8, null);
                    throw Error.error(460, e);
                }
                catch (Throwable t) {
                    throw Error.error(458, t);
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                try {
                    if (this.randomAccessOut != null) {
                        this.randomAccessOut.close();
                    }
                }
                catch (Throwable t) {
                    complete = false;
                }
                if (!complete) {
                    this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
                }
                throw throwable;
            }
        }
        this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
    }

    void updateTableIndexRoots() {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() != 5) continue;
            int[] rootsArray = this.rootsList[i];
            t.setIndexRoots(rootsArray);
        }
    }

    void updateTransactionRowIDs() {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore store = table.getRowStore(session);
        RowOutputInterface rowOut = this.cache.rowOut.duplicate();
        int[] rootsArray = table.getIndexRootsArray();
        long pos = this.fileOffset;
        int count = 0;
        this.pointerLookup.removeAll();
        this.pointerLookup.setKeysSearchTarget();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().name + " " + this.stopw.elapsedTime());
        RowIterator it = table.rowIteratorClustered(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            this.pointerLookup.addUnsorted(row.getPos(), (int)(pos / (long)this.scale));
            if (count != 0 && count % 100000 == 0) {
                this.database.logger.logDetailEvent("pointer pair for row " + count + " " + row.getPos() + " " + pos);
            }
            pos += (long)row.getStorageSize();
            ++count;
        }
        this.database.logger.logDetailEvent("table read " + table.getName().name + " " + this.stopw.elapsedTime());
        count = 0;
        it = table.rowIteratorClustered(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            rowOut.reset();
            row.write(rowOut, this.pointerLookup);
            this.randomAccessOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
            this.fileOffset += (long)row.getStorageSize();
            if (count != 0 && count % 100000 == 0) {
                this.database.logger.logDetailEvent("rows count " + count + " " + this.stopw.elapsedTime());
            }
            ++count;
        }
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (rootsArray[i] == -1) continue;
            int lookupIndex = this.pointerLookup.findFirstEqualKeyIndex(rootsArray[i]);
            if (lookupIndex == -1) {
                throw Error.error(466);
            }
            rootsArray[i] = this.pointerLookup.getValue(lookupIndex);
        }
        this.setTransactionRowLookups(this.pointerLookup);
        this.database.logger.logDetailEvent("table written " + table.getName().name);
        return rootsArray;
    }

    public int[][] getIndexRoots() {
        return this.rootsList;
    }

    void setTransactionRowLookups(DoubleIntIndex pointerLookup) {
        int size = this.transactionRowLookup.size();
        for (int i = 0; i < size; ++i) {
            int key = this.transactionRowLookup.getKey(i);
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(key);
            if (lookupIndex == -1) continue;
            this.transactionRowLookup.setValue(i, pointerLookup.getValue(lookupIndex));
        }
    }

    static boolean checkAllTables(Database database) {
        Session session = database.getSessionManager().getSysSession();
        HsqlArrayList allTables = database.schemaManager.getAllTables(true);
        int tSize = allTables.size();
        for (int i = 0; i < tSize; ++i) {
            Table t = (Table)allTables.get(i);
            int count = 0;
            if (t.getTableType() != 5) continue;
            RowIterator it = t.rowIterator(session);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                ++count;
            }
            System.out.println("table " + t.getName().name + " " + count);
        }
        return true;
    }
}

