/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.BasePACLPolicy;
import com.liferay.portal.security.pacl.checker.Checker;
import com.liferay.portal.security.pacl.checker.JNDIChecker;
import com.liferay.portal.security.pacl.checker.SQLChecker;
import java.security.Permission;
import java.util.Properties;

public class ActivePACLPolicy
extends BasePACLPolicy {
    private static Log _log = LogFactoryUtil.getLog(ActivePACLPolicy.class);
    private JNDIChecker _jndiChecker;
    private SQLChecker _sqlChecker;

    public ActivePACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        super(servletContextName, classLoader, properties);
        try {
            this.initJNDIChecker();
            this.initSQLChecker();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public JNDIChecker getJndiChecker() {
        return this._jndiChecker;
    }

    public SQLChecker getSqlChecker() {
        return this._sqlChecker;
    }

    @Override
    public boolean hasJNDI(String name) {
        return this._jndiChecker.hasJNDI(name);
    }

    @Override
    public boolean hasSQL(String sql) {
        return this._sqlChecker.hasSQL(sql);
    }

    @Override
    public boolean implies(Permission permission) {
        Checker checker = this.getChecker(permission.getClass());
        return checker.implies(permission);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected void initJNDIChecker() {
        this._jndiChecker = new JNDIChecker();
        this.initChecker(this._jndiChecker);
    }

    protected void initSQLChecker() {
        this._sqlChecker = new SQLChecker();
        this.initChecker(this._sqlChecker);
    }
}

