/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.PropertyImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import java.sql.SQLException;

public class ResultSetStatementIterator
extends ResultSetIterator {
    protected ModelRDB m_model;
    protected IRDBDriver m_driver;
    protected int m_nrows = -1;
    protected Statement m_row;

    public ResultSetStatementIterator(ModelRDB modelRDB, IRDBDriver iRDBDriver) {
        this.m_model = modelRDB;
        this.m_driver = iRDBDriver;
    }

    protected void extractRow() throws SQLException, RDFException {
        IDBID iDBID;
        Object object;
        Object object2;
        if (this.m_nrows == -1) {
            this.m_nrows = this.m_resultSet.getMetaData().getColumnCount();
        }
        boolean bl = this.m_nrows == 8;
        int n = 1;
        Resource resource = null;
        IDBID iDBID2 = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        if (bl) {
            object2 = this.m_resultSet.getString(n++);
            object = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
            resource = this.m_driver.makeResource(iDBID2, (String)object2, (IDBID)object, this.m_model);
        } else {
            resource = this.m_driver.getResource(iDBID2, this.m_model);
        }
        object2 = null;
        iDBID2 = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        if (bl) {
            object = this.m_resultSet.getString(n++);
            iDBID = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
            object2 = new PropertyImplRDB(this.m_driver.getNamespace(iDBID), (String)object, this.m_model);
            ((ResourceImplRDB)object2).setRDBId(iDBID2);
            ((ResourceImplRDB)object2).setRDBNSId(iDBID);
        } else {
            object2 = (PropertyImplRDB)this.m_driver.getProperty(iDBID2, this.m_model);
        }
        object = null;
        iDBID = this.m_driver.wrapDBID(this.m_resultSet.getObject(n++));
        int n2 = this.m_resultSet.getInt(n++);
        object = n2 == 1 ? this.m_driver.getLiteral(iDBID) : this.m_driver.getResource(iDBID, this.m_model);
        this.m_row = new StatementImpl(resource, (Property)object2, (RDFNode)object, this.m_model);
    }

    protected Object getRow() {
        return this.m_row;
    }

    public void remove() {
        if (!this.m_finished && this.m_row != null) {
            try {
                this.m_model.remove(this.m_row);
            }
            catch (RDFException rDFException) {
                throw new IllegalStateException("Error during remove(): " + rDFException);
            }
        }
    }
}

