/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.GelAnalyzer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class PlotsCanvas
extends ImageCanvas {
    public static final int MAX_PEAKS = 200;
    double[] actual = new double[]{428566.0, 351368.0, 233977.0, 99413.0, 60057.0, 31382.0, 14531.0, 7843.0, 2146.0, 752.0, 367.0};
    double[] measured = new double[200];
    Rectangle[] rect = new Rectangle[200];
    int counter;
    ResultsTable rt;

    public PlotsCanvas(ImagePlus imp) {
        super(imp);
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return;
        }
        if (roi.getType() == 5) {
            Roi.setColor(Color.blue);
        } else {
            Roi.setColor(Color.yellow);
        }
        if (Toolbar.getToolId() != 8 || IJ.spaceBarDown()) {
            return;
        }
        if (IJ.shiftKeyDown()) {
            IJ.showMessage("Gel Analyzer", "Unable to measure area because shift key is down.");
            this.imp.killRoi();
            this.counter = 0;
            return;
        }
        ImageStatistics s = this.imp.getStatistics();
        if (this.counter == 0) {
            this.rt = ResultsTable.getResultsTable();
            this.rt.reset();
        }
        double perimeter = roi.getLength();
        String error = "";
        double circularity = Math.PI * 4 * ((double)s.pixelCount / (perimeter * perimeter));
        if (circularity < 0.025) {
            error = " (error?)";
        }
        double area = (double)s.pixelCount + perimeter / 2.0;
        Calibration cal = this.imp.getCalibration();
        area = area * cal.pixelWidth * cal.pixelHeight;
        this.rect[this.counter] = roi.getBounds();
        int places = cal.scaled() ? 3 : 0;
        this.rt.incrementCounter();
        this.rt.addValue("Area", area);
        this.rt.show("Results");
        this.measured[this.counter] = area;
        if (this.counter < 200) {
            ++this.counter;
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Undo.setup(1, this.imp);
            this.imp.getProcessor().snapshot();
            roi.drawPixels();
            this.imp.updateAndDraw();
            this.imp.killRoi();
        }
    }

    void reset() {
        this.counter = 0;
    }

    void labelPeaks() {
        this.imp.killRoi();
        double total = 0.0;
        for (int i = 0; i < this.counter; ++i) {
            total += this.measured[i];
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setFont(new Font("SansSerif", 0, 9));
        for (int i = 0; i < this.counter; ++i) {
            Rectangle r = this.rect[i];
            String s = GelAnalyzer.labelWithPercentages ? IJ.d2s(this.measured[i] / total * 100.0, 2) : IJ.d2s(this.measured[i], 0);
            int swidth = ip.getStringWidth(s);
            int x = r.x + r.width / 2 - swidth / 2;
            int y = r.y + r.height * 3 / 4 + 9;
            int[] data = new int[swidth];
            ip.getRow(x, y, data, swidth);
            boolean fits = true;
            for (int j = 0; j < swidth; ++j) {
                if (data[j] == 255) continue;
                fits = false;
                break;
            }
            boolean bl = fits = fits && this.measured[i] > 500.0;
            if (r.height >= GelAnalyzer.plotHeight - 11) {
                fits = true;
            }
            if (!fits) {
                y = r.y - 2;
            }
            ip.drawString(s, x, y);
        }
        this.imp.updateAndDraw();
        this.displayPercentages();
        this.reset();
    }

    void displayPercentages() {
        int i;
        ResultsTable rt = ResultsTable.getResultsTable();
        rt.reset();
        double total = 0.0;
        for (i = 0; i < this.counter; ++i) {
            total += this.measured[i];
        }
        if (IJ.debugMode && this.counter == this.actual.length) {
            this.debug();
            return;
        }
        for (i = 0; i < this.counter; ++i) {
            double percent = this.measured[i] / total * 100.0;
            rt.incrementCounter();
            rt.addValue("Area", this.measured[i]);
            rt.addValue("Percent", percent);
        }
        rt.show("Results");
    }

    void debug() {
        for (int i = 0; i < this.counter; ++i) {
            double a = this.actual[i] / this.actual[0] * 100.0;
            double m = this.measured[i] / this.measured[0] * 100.0;
            IJ.write(IJ.d2s(a, 4) + " " + IJ.d2s(m, 4) + " " + IJ.d2s((m - a) / m * 100.0, 4));
        }
    }
}

