/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.threadlocalexec;

import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartGearsPortalValve
extends ValveBase {
    private static final Logger _log = LoggerFactory.getLogger(SmartGearsPortalValve.class);
    private static final String DEFAULT_ROLE = "OrganizationMember";
    private static final String LIFERAY_POLLER_CONTEXT = "poller/receive";

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        SecurityTokenProvider.instance.reset();
        ScopeProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        if (req instanceof HttpServletRequest) {
            Request request = req;
            if (!req.getRequestURL().toString().endsWith(LIFERAY_POLLER_CONTEXT)) {
                PortalContext context = PortalContext.getConfiguration();
                String scope = context.getCurrentScope((HttpServletRequest)request);
                String username = SmartGearsPortalValve.getCurrentUsername((HttpServletRequest)request);
                if (scope != null && username != null) {
                    String userToken = null;
                    try {
                        ScopeProvider.instance.set(scope);
                        userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                    }
                    catch (ObjectNotFound ex) {
                        userToken = SmartGearsPortalValve.generateAuthorizationToken(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                        _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
                    }
                    catch (Exception e) {
                        _log.error("Something went wrong in generating token for " + username + " in scope " + scope);
                        e.printStackTrace();
                    }
                }
            }
        }
        this.getNext().invoke(req, resp);
    }

    private static String generateAuthorizationToken(String username, String scope) {
        String token;
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add(DEFAULT_ROLE);
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(username, userRoles), scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return token;
    }

    public static String getCurrentUsername(HttpServletRequest httpServletRequest) {
        String userIdNo = httpServletRequest.getHeader("gcube-userId");
        if (userIdNo != null && userIdNo.compareTo("undefined") != 0) {
            long userId = -1L;
            try {
                userId = Long.parseLong(userIdNo);
                return UserLocalServiceUtil.getUser((long)userId).getScreenName();
            }
            catch (NumberFormatException e) {
                _log.error("The userId is not a number -> " + userIdNo);
                return null;
            }
            catch (Exception e) {
                _log.error("The userId does not belong to any user -> " + userIdNo);
                return null;
            }
        }
        return null;
    }
}

