/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.collect.Lists;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.impl.AbstractLatencyScoreStrategyImpl;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;

public class EmaLatencyScoreStrategyImpl
extends AbstractLatencyScoreStrategyImpl {
    private static final String NAME = "EMA";
    private final int N;
    private final double k;
    private final double one_minus_k;

    public EmaLatencyScoreStrategyImpl(int updateInterval, int resetInterval, int windowSize, int blockedThreshold, double keepRatio, double scoreThreshold) {
        super(NAME, updateInterval, resetInterval, blockedThreshold, keepRatio, scoreThreshold);
        this.N = windowSize;
        this.k = 2.0 / (double)(this.N + 1);
        this.one_minus_k = 1.0 - this.k;
    }

    public EmaLatencyScoreStrategyImpl(int updateInterval, int resetInterval, int windowSize) {
        super(NAME, updateInterval, resetInterval);
        this.N = windowSize;
        this.k = 2.0 / (double)(this.N + 1);
        this.one_minus_k = 1.0 - this.k;
    }

    public EmaLatencyScoreStrategyImpl(int windowSize) {
        super(NAME);
        this.N = windowSize;
        this.k = 2.0 / (double)(this.N + 1);
        this.one_minus_k = 1.0 - this.k;
    }

    @Override
    public final LatencyScoreStrategy.Instance newInstance() {
        return new LatencyScoreStrategy.Instance(){
            private final LinkedBlockingQueue<Long> latencies;
            private volatile double cachedScore;
            {
                this.latencies = new LinkedBlockingQueue(EmaLatencyScoreStrategyImpl.this.N);
                this.cachedScore = 0.0;
            }

            @Override
            public void addSample(long sample) {
                if (!this.latencies.offer(sample)) {
                    try {
                        this.latencies.remove();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    this.latencies.offer(sample);
                }
            }

            @Override
            public double getScore() {
                return this.cachedScore;
            }

            @Override
            public void reset() {
                this.cachedScore = 0.0;
                this.latencies.clear();
            }

            @Override
            public void update() {
                Double ema = this.cachedScore;
                ArrayList samples = Lists.newArrayList();
                this.latencies.drainTo(samples);
                if (samples.size() == 0) {
                    samples.add(0L);
                }
                if (ema == 0.0) {
                    ema = (double)((Long)samples.remove(0));
                }
                for (Long sample : samples) {
                    ema = (double)sample.longValue() * EmaLatencyScoreStrategyImpl.this.k + ema * EmaLatencyScoreStrategyImpl.this.one_minus_k;
                }
                this.cachedScore = ema;
            }
        };
    }
}

