/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScanner;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseFileAntivirusScanner
implements AntivirusScanner {
    private static final boolean _ACTIVE = true;
    private static final String _ANTIVIRUS_EXTENSION = "avs";

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void scan(byte[] bytes) throws AntivirusScannerException, SystemException {
        File file = null;
        try {
            try {
                file = FileUtil.createTempFile(_ANTIVIRUS_EXTENSION);
                FileUtil.write(file, bytes);
                this.scan(file);
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to write temporary file", ioe);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public void scan(InputStream inputStream) throws AntivirusScannerException, SystemException {
        File file = null;
        try {
            try {
                file = FileUtil.createTempFile(_ANTIVIRUS_EXTENSION);
                FileUtil.write(file, inputStream);
                this.scan(file);
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to write temporary file", ioe);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

