/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.jtx;

import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.jtx.DbJtxTransaction;
import jodd.jtx.JtxTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbJtxSessionProvider
implements DbSessionProvider {
    private static final Logger log = LoggerFactory.getLogger(DbJtxSessionProvider.class);
    protected final JtxTransactionManager jtxTxManager;

    public DbJtxSessionProvider(JtxTransactionManager txManager) {
        this.jtxTxManager = txManager;
    }

    public DbSession getDbSession() {
        DbJtxTransaction jtx;
        if (log.isDebugEnabled()) {
            log.debug("Requesting db TX manager session");
        }
        if ((jtx = (DbJtxTransaction)this.jtxTxManager.getTransaction()) == null) {
            throw new DbSqlException("No transaction is in progress and DbSession can't be provided. It seems that transaction manager is not used to begin a transaction.");
        }
        return jtx.requestResource();
    }
}

