/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;

public class PolarFilter
extends TransformFilter {
    public static final int RECT_TO_POLAR = 0;
    public static final int POLAR_TO_RECT = 1;
    public static final int INVERT_IN_CIRCLE = 2;
    private int type;
    private double width;
    private double height;
    private double centreX;
    private double centreY;
    private double radius;

    public PolarFilter() {
        this(0);
    }

    public PolarFilter(int n) {
        this.type = n;
        this.setEdgeAction(1);
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.width = n;
        this.height = n2;
        this.centreX = n / 2;
        this.centreY = n2 / 2;
        this.radius = Math.min(this.centreY, this.centreX);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    private double sqr(double d) {
        return d * d;
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        double d = 0.0;
        switch (this.type) {
            case 0: {
                double d2 = 0.0;
                if ((double)n >= this.centreX) {
                    if ((double)n2 > this.centreY) {
                        d2 = Math.PI - Math.atan(((double)n - this.centreX) / ((double)n2 - this.centreY));
                        d = Math.sqrt(this.sqr((double)n - this.centreX) + this.sqr((double)n2 - this.centreY));
                    } else if ((double)n2 < this.centreY) {
                        d2 = Math.atan(((double)n - this.centreX) / (this.centreY - (double)n2));
                        d = Math.sqrt(this.sqr((double)n - this.centreX) + this.sqr(this.centreY - (double)n2));
                    } else {
                        d2 = 1.5707963267948966;
                        d = (double)n - this.centreX;
                    }
                } else if ((double)n < this.centreX) {
                    if ((double)n2 < this.centreY) {
                        d2 = Math.PI * 2 - Math.atan((this.centreX - (double)n) / (this.centreY - (double)n2));
                        d = Math.sqrt(this.sqr(this.centreX - (double)n) + this.sqr(this.centreY - (double)n2));
                    } else if ((double)n2 > this.centreY) {
                        d2 = Math.PI + Math.atan((this.centreX - (double)n) / ((double)n2 - this.centreY));
                        d = Math.sqrt(this.sqr(this.centreX - (double)n) + this.sqr((double)n2 - this.centreY));
                    } else {
                        d2 = 4.71238898038469;
                        d = this.centreX - (double)n;
                    }
                }
                double d3 = (double)n != this.centreX ? Math.abs(((double)n2 - this.centreY) / ((double)n - this.centreX)) : 0.0;
                if (d3 <= this.height / this.width) {
                    if ((double)n == this.centreX) {
                        double d4 = 0.0;
                        double d5 = this.centreY;
                    } else {
                        double d6 = this.centreX;
                        double d7 = d3 * d6;
                    }
                } else {
                    double d8 = this.centreY;
                    double d9 = d8 / d3;
                }
                dArray[0] = this.width - 1.0 - (this.width - 1.0) / (Math.PI * 2) * d2;
                dArray[1] = this.height * d / this.radius;
                break;
            }
            case 1: {
                double d10 = (double)n / this.width * 2.0 * Math.PI;
                double d11 = d10 >= 4.71238898038469 ? Math.PI * 2 - d10 : (d10 >= Math.PI ? d10 - Math.PI : (d10 >= 1.5707963267948966 ? Math.PI - d10 : d10));
                double d12 = Math.tan(d11);
                double d13 = d12 != 0.0 ? 1.0 / d12 : 0.0;
                if (d13 <= this.height / this.width) {
                    if (d11 == 0.0) {
                        double d14 = 0.0;
                        double d15 = this.centreY;
                    } else {
                        double d16 = this.centreX;
                        double d17 = d13 * d16;
                    }
                } else {
                    double d18 = this.centreY;
                    double d19 = d18 / d13;
                }
                d = this.radius * ((double)n2 / this.height);
                double d20 = -d * Math.sin(d11);
                double d21 = d * Math.cos(d11);
                if (d10 >= 4.71238898038469) {
                    dArray[0] = this.centreX - d20;
                    dArray[1] = this.centreY - d21;
                    break;
                }
                if (d10 >= Math.PI) {
                    dArray[0] = this.centreX - d20;
                    dArray[1] = this.centreY + d21;
                    break;
                }
                if (d10 >= 1.5707963267948966) {
                    dArray[0] = this.centreX + d20;
                    dArray[1] = this.centreY + d21;
                    break;
                }
                dArray[0] = this.centreX + d20;
                dArray[1] = this.centreY - d21;
                break;
            }
            case 2: {
                double d22 = (double)n - this.centreX;
                double d23 = (double)n2 - this.centreY;
                double d24 = d22 * d22 + d23 * d23;
                dArray[0] = this.centreX + this.centreX * this.centreX * d22 / d24;
                dArray[1] = this.centreY + this.centreY * this.centreY * d23 / d24;
                break;
            }
        }
    }

    public String toString() {
        return "Distort/Polar Coordinates...";
    }
}

