/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.language;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletConfig;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(LanguageFilter.class);
    private static Pattern _pattern = Pattern.compile("Liferay\\.Language\\.get\\([\"']([^)]+)[\"']\\)");
    private PortletConfig _portletConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        ServletContext servletContext = filterConfig.getServletContext();
        PortletApp portletApp = (PortletApp)servletContext.getAttribute("com.liferay.portal.model.PortletApp");
        if (portletApp == null || !portletApp.isWARFile()) {
            return;
        }
        List portlets = portletApp.getPortlets();
        if (portlets.size() <= 0) {
            return;
        }
        this._portletConfig = PortletConfigFactoryUtil.create((Portlet)((Portlet)portlets.get(0)), (ServletContext)filterConfig.getServletContext());
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        this.processFilter(LanguageFilter.class, request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            _log.debug((Object)("Translating response " + completeURL));
        }
        String content = bufferCacheServletResponse.getString();
        content = this.translateResponse(request, content);
        ServletResponseUtil.write((HttpServletResponse)response, (String)content);
    }

    protected String translateResponse(HttpServletRequest request, String content) {
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        StringBundler sb = new StringBundler();
        Matcher matcher = _pattern.matcher(content);
        int x = 0;
        while (matcher.find()) {
            int y = matcher.start(0);
            String key = matcher.group(1);
            sb.append(content.substring(x, y));
            sb.append("'");
            String value = null;
            value = this._portletConfig != null ? UnicodeLanguageUtil.get((PortletConfig)this._portletConfig, (Locale)locale, (String)key) : UnicodeLanguageUtil.get((Locale)locale, (String)key);
            sb.append(value);
            sb.append("'");
            x = matcher.end(0);
        }
        sb.append(content.substring(x));
        return sb.toString();
    }
}

