/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.notifications;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationManager;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.ServiceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserNotificationManagerImpl
implements UserNotificationManager {
    private static Log _log = LogFactoryUtil.getLog(UserNotificationManagerImpl.class);
    private Map<String, List<UserNotificationDefinition>> _userNotificationDefinitions = new HashMap<String, List<UserNotificationDefinition>>();
    private Map<String, Map<String, UserNotificationHandler>> _userNotificationHandlers = new HashMap<String, Map<String, UserNotificationHandler>>();

    public void addUserNotificationDefinition(String portletId, UserNotificationDefinition userNotificationDefinition) {
        List<UserNotificationDefinition> userNotificationDefinitions = this._userNotificationDefinitions.get(portletId);
        if (userNotificationDefinitions == null) {
            userNotificationDefinitions = new ArrayList<UserNotificationDefinition>();
            this._userNotificationDefinitions.put(portletId, userNotificationDefinitions);
        }
        userNotificationDefinitions.add(userNotificationDefinition);
    }

    public void addUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        String selector = userNotificationHandler.getSelector();
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            userNotificationHandlers = new HashMap<String, UserNotificationHandler>();
            this._userNotificationHandlers.put(selector, userNotificationHandlers);
        }
        userNotificationHandlers.put(userNotificationHandler.getPortletId(), userNotificationHandler);
    }

    public void deleteUserNotificationDefinitions(String portletId) {
        this._userNotificationDefinitions.remove(portletId);
    }

    public void deleteUserNotificationHandler(UserNotificationHandler userNotificationHandler) {
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(userNotificationHandler.getSelector());
        if (userNotificationHandlers == null) {
            return;
        }
        userNotificationHandlers.remove(userNotificationHandler.getPortletId());
    }

    public UserNotificationDefinition fetchUserNotificationDefinition(String portletId, long classNameId, int notificationType) {
        List<UserNotificationDefinition> userNotificationDefinitions = this._userNotificationDefinitions.get(portletId);
        if (userNotificationDefinitions == null) {
            return null;
        }
        for (UserNotificationDefinition userNotificationDefinition : userNotificationDefinitions) {
            if (userNotificationDefinition.getClassNameId() != classNameId || userNotificationDefinition.getNotificationType() != notificationType) continue;
            return userNotificationDefinition;
        }
        return null;
    }

    public Map<String, List<UserNotificationDefinition>> getUserNotificationDefinitions() {
        return Collections.unmodifiableMap(this._userNotificationDefinitions);
    }

    public Map<String, Map<String, UserNotificationHandler>> getUserNotificationHandlers() {
        return Collections.unmodifiableMap(this._userNotificationHandlers);
    }

    public UserNotificationFeedEntry interpret(String selector, UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return null;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(userNotificationEvent.getType());
        if (userNotificationHandler == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No interpreter found for " + userNotificationEvent));
            }
            return null;
        }
        return userNotificationHandler.interpret(userNotificationEvent, serviceContext);
    }

    public boolean isDeliver(long userId, String portletId, long classNameId, int notificationType, int deliveryType) throws PortalException, SystemException {
        return this.isDeliver(userId, "", portletId, classNameId, notificationType, deliveryType, null);
    }

    public boolean isDeliver(long userId, String selector, String portletId, long classNameId, int notificationType, int deliveryType, ServiceContext serviceContext) throws PortalException, SystemException {
        Map<String, UserNotificationHandler> userNotificationHandlers = this._userNotificationHandlers.get(selector);
        if (userNotificationHandlers == null) {
            return false;
        }
        UserNotificationHandler userNotificationHandler = userNotificationHandlers.get(portletId);
        if (userNotificationHandler == null) {
            return false;
        }
        return userNotificationHandler.isDeliver(userId, classNameId, notificationType, deliveryType, serviceContext);
    }
}

