/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.tasks;

import java.io.InputStream;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.utils.handlers.GCUBEStagingServiceHandler;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.dir.master.contexts.ServiceContext;
import org.gcube.dir.master.state.Collection;
import org.gcube.dir.master.tasks.IndexFinder;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.CreateResource;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.CreateStatistics;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.FullTextIndexLookupFactoryPortType;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.FullTextIndexLookupPortType;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.service.FullTextIndexLookupFactoryServiceAddressingLocator;
import org.gcube.indexmanagement.fulltextindexlookup.stubs.service.FullTextIndexLookupServiceAddressingLocator;

public class DescriptionFinder<T extends Collection>
extends GCUBEStagingServiceHandler<T> {
    protected static final String FULLTEXT_INDEX_NAME = "FullTextIndexLookup";
    protected static final String FACTORY_NAME = "gcube/indexmanagement/fulltextindexlookup/FullTextIndexLookupFactory";
    protected static final String INDEX_COLLECTIONID_RP_NAME = "CollectionID";
    protected static final String INDEX_HEADPARTITION_RP_NAME = "IsHeadPartition";
    InputStream stream;

    protected String getTargetPortTypeName() {
        return FULLTEXT_INDEX_NAME;
    }

    protected List<RPDocument> findWSResources() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery query = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/gc:ServiceName", FULLTEXT_INDEX_NAME), new AtomicCondition("/*[local-name() eq 'CollectionID']", (String)((Collection)((Object)this.getHandled())).getID()), new AtomicCondition("/*[local-name() eq 'IsHeadPartition']", "true")});
        return client.execute((ISQuery)query, ServiceContext.getContext().getScope());
    }

    protected List<EndpointReferenceType> findFactories() throws Exception {
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", FULLTEXT_INDEX_NAME)});
        for (GCUBERunningInstance instance : client.execute((ISQuery)lookupQuery, ServiceContext.getContext().getScope())) {
            eprs.add(instance.getAccessPoint().getEndpoint(FACTORY_NAME));
        }
        return eprs;
    }

    protected EndpointReferenceType createInstance(EndpointReferenceType epr) throws Exception {
        IndexFinder indexFinder = new IndexFinder();
        indexFinder.setHandled(this.getHandled());
        indexFinder.run();
        FullTextIndexLookupFactoryPortType factory = new FullTextIndexLookupFactoryServiceAddressingLocator().getFullTextIndexLookupFactoryPortTypePort(epr);
        factory = (FullTextIndexLookupFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)factory, (GCUBEServiceContext)ServiceContext.getContext());
        CreateResource cr = new CreateResource();
        cr.setMainIndexID(indexFinder.getIndexID());
        return factory.createResource(cr).getEndpointReference();
    }

    protected void interact(EndpointReferenceType epr) throws Exception {
        FullTextIndexLookupPortType lookup = new FullTextIndexLookupServiceAddressingLocator().getFullTextIndexLookupPortTypePort(epr);
        lookup = (FullTextIndexLookupPortType)GCUBERemotePortTypeContext.getProxy((Remote)lookup, (GCUBEServiceContext)ServiceContext.getContext());
        String resultSetEPR = lookup.createStatistics(new CreateStatistics());
        RSBLOBIterator iterator = RSBLOBReader.getRSBLOBReader((RSLocator)new RSLocator(resultSetEPR)).makeLocal((RSResourceType)new RSResourceLocalType()).getRSIterator();
        ResultElementBLOBGeneric blob = null;
        while (blob == null && iterator.hasNext()) {
            blob = (ResultElementBLOBGeneric)iterator.next(ResultElementBLOBGeneric.class);
        }
        if (blob == null) {
            throw new Exception("Invalid statistics from Index services: no payload");
        }
        this.stream = blob.getContentOfBLOB();
    }

    public InputStream getStatisticsAsStream() {
        return this.stream;
    }
}

