/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.dir.master.contexts.MasterContext;
import org.gcube.dir.master.state.Collection;
import org.gcube.dir.master.stubs.FactoryParams;

public class CollectionSet
extends GCUBEWSResource {
    protected static final String RP_COLLECTIONIDs = "CollectionIDs";
    protected static String[] RPNames = new String[]{"CollectionIDs"};

    protected void initialise(Object ... params) throws Exception {
        FactoryParams p = (FactoryParams)params[0];
        if (p == null || p.getCollectionIDs() == null || p.getCollectionIDs().length == 0) {
            return;
        }
        this.addCollections(p.getCollectionIDs());
    }

    public int getSize() {
        return this.getCollectionIDs().size();
    }

    public synchronized List<String> getCollectionIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        Iterator i = this.getResourcePropertySet().get(RP_COLLECTIONIDs).iterator();
        while (i.hasNext()) {
            ids.add((String)i.next());
        }
        return ids;
    }

    public synchronized void setCollectionIDs(List<String> ids) {
        for (String id : ids) {
            this.getResourcePropertySet().get(RP_COLLECTIONIDs).add((Object)id);
        }
    }

    public synchronized Map<String, Collection> getCollections(String ... ids) {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        if (ids.length == 0) {
            ids = this.getCollectionIDs().toArray(new String[0]);
        }
        for (String id : ids) {
            try {
                map.put(id, (Collection)MasterContext.getContext().getLocalHome().find((Object)id));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Collection " + id + " no longer available, removing it from CollectionSet " + this.getID()));
                this.removeCollections(id);
            }
        }
        return map;
    }

    public long getDocumentSize() {
        long size = 0L;
        for (Collection c : this.getCollections(new String[0]).values()) {
            size += c.getNumberOfDocuments();
        }
        return size;
    }

    public synchronized void addCollections(String ... ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("no collections specified");
        }
        List<String> currentIDs = this.getCollectionIDs();
        for (String id : ids) {
            if (currentIDs.contains(id)) continue;
            try {
                MasterContext.getContext().getLocalHome().create((Object)id, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
            this.getResourcePropertySet().get(RP_COLLECTIONIDs).add((Object)id);
            this.logger.info((Object)("Added collection " + id + " to CollectionSet " + this.getID()));
        }
    }

    public void removeCollections(String ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("Null or empty input");
        }
        this.logger.debug((Object)("Removing collections " + Arrays.asList(ids) + " from CollectionSet " + this.getID()));
        for (String id : ids) {
            if (!this.getResourcePropertySet().get(RP_COLLECTIONIDs).remove((Object)id)) continue;
            try {
                MasterContext.getContext().getLocalHome().remove((Object)id);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Could not remove collection " + id + " from CollectionSet " + this.getID()), (Throwable)e);
            }
        }
    }

    public String[] getPropertyNames() {
        return RPNames;
    }
}

