/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.selection.rankers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dir.master.Prototyped;
import org.gcube.dir.master.contexts.ServiceContext;
import org.gcube.dir.master.index.DefaultTermStats;
import org.gcube.dir.master.index.IndexManager;
import org.gcube.dir.master.queries.DefaultQuery;
import org.gcube.dir.master.queries.DefaultQueryTerm;
import org.gcube.dir.master.selection.io.CollectionRank;
import org.gcube.dir.master.selection.io.SelectionParameters;
import org.gcube.dir.master.selection.rankers.Ranker;
import org.gcube.dir.master.state.Collection;
import org.gcube.dir.master.state.CollectionSet;

public class CORIRanker
implements Ranker<SelectionParameters, CollectionRank>,
Prototyped<SelectionParameters> {
    protected final GCUBELog logger = new GCUBELog((Object)this);

    @Override
    public List<CollectionRank> rank(SelectionParameters params, CollectionSet set) throws Exception {
        IndexManager<?, ?> manager = ServiceContext.getContext().getIndexManager();
        DefaultQuery query = (DefaultQuery)params.getQuery();
        List<? extends DefaultQueryTerm> terms = query.getTerms();
        float b = 0.4f;
        int numOfSources = set.getSize();
        int sum_cw = 0;
        Map<String, Collection> collections = set.getCollections(new String[0]);
        HashMap<Object, CollectionRank> entryMap = new HashMap<Object, CollectionRank>();
        for (Collection coll : collections.values()) {
            sum_cw = (int)((long)sum_cw + coll.getNumberOfTerms());
            entryMap.put(coll.getID(), new CollectionRank((String)coll.getID(), 0.0f));
        }
        float avg_cw = sum_cw / numOfSources;
        for (DefaultQueryTerm defaultQueryTerm : terms) {
            Map<String, ?> postings = manager.getPostings(defaultQueryTerm.getName(), set.getCollectionIDs());
            for (String matchingID : postings.keySet()) {
                DefaultTermStats stats = (DefaultTermStats)postings.get(matchingID);
                int df = stats.getDocFrequency();
                long cw = collections.get(matchingID).getNumberOfTerms();
                float T = (float)df / ((float)(df + 50) + (float)(150L * cw) / avg_cw);
                float I = (float)(Math.log(((double)numOfSources + 0.5) / (double)postings.size()) / Math.log((double)numOfSources + 1.0));
                float p = b + (1.0f - b) * T * I;
                ((CollectionRank)entryMap.get(matchingID)).setScore(((CollectionRank)entryMap.get(matchingID)).getScore() + p);
            }
        }
        ArrayList<CollectionRank> rankEntries = new ArrayList<CollectionRank>(entryMap.values());
        Collections.sort(rankEntries);
        return rankEntries;
    }

    @Override
    public SelectionParameters getPrototype() {
        return new SelectionParameters(new DefaultQuery(new ArrayList()), null);
    }
}

