/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.selection.criteria;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dir.master.selection.criteria.SelectionCriterion;
import org.gcube.dir.master.selection.io.CollectionRank;
import org.gcube.dir.master.selection.io.ExtendedCollectionRank;

public class ResultDistributionCriterion
implements SelectionCriterion {
    int numberOfResults;

    public ResultDistributionCriterion(int numberOfResults) {
        this.numberOfResults = numberOfResults;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int numberOfResult) {
        this.numberOfResults = numberOfResult;
    }

    public <T extends CollectionRank> List<ExtendedCollectionRank> select(List<T> ranking) {
        float mins = ((CollectionRank)ranking.get(0)).getScore();
        float maxs = ((CollectionRank)ranking.get(0)).getScore();
        float tots = 0.0f;
        for (CollectionRank entry : ranking) {
            float score = entry.getScore();
            if (mins > score) {
                mins = score;
            } else if (maxs < score) {
                maxs = score;
            }
            tots += score;
        }
        float adj = mins < 0.0f ? -mins : 0.0f;
        boolean pathological = Math.round((maxs + adj) / (tots += adj * (float)ranking.size())) < 1;
        ArrayList<ExtendedCollectionRank> entryList = new ArrayList<ExtendedCollectionRank>();
        for (CollectionRank entry : ranking) {
            float results = (entry.getScore() + adj) / tots * (float)this.getNumberOfResults();
            if (!((double)results > 0.5) || pathological) continue;
            entryList.add(new ExtendedCollectionRank(entry.getCollectionID(), entry.getScore(), Math.round(results)));
        }
        return entryList;
    }
}

